/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.kernel.api.QueryRegistry;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.util.MonotonicCounter;
import org.neo4j.resources.CpuClock;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.values.virtual.MapValue;

public class StatementQueryRegistry
implements QueryRegistry {
    private static final MonotonicCounter lastQueryId = MonotonicCounter.newAtomicMonotonicCounter();
    private final KernelStatement statement;
    private final SystemNanoClock clock;
    private final AtomicReference<CpuClock> cpuClockRef;
    private final NamedDatabaseId namedDatabaseId;

    StatementQueryRegistry(KernelStatement statement, SystemNanoClock clock, AtomicReference<CpuClock> cpuClockRef, NamedDatabaseId namedDatabaseId) {
        this.statement = statement;
        this.clock = clock;
        this.cpuClockRef = cpuClockRef;
        this.namedDatabaseId = namedDatabaseId;
    }

    @Override
    public Optional<ExecutingQuery> executingQuery() {
        return this.statement.executingQuery();
    }

    @Override
    public void registerExecutingQuery(ExecutingQuery executingQuery) {
        this.statement.startQueryExecution(executingQuery);
    }

    @Override
    public ExecutingQuery startQueryExecution(String queryText, MapValue queryParameters) {
        long queryId = lastQueryId.incrementAndGet();
        Thread thread = Thread.currentThread();
        long threadId = thread.getId();
        String threadName = thread.getName();
        KernelTransactionImplementation transaction = this.statement.getTransaction();
        ExecutingQuery executingQuery = new ExecutingQuery(queryId, transaction.clientInfo(), this.namedDatabaseId, this.statement.username(), queryText, queryParameters, transaction.getMetaData(), () -> this.statement.locks().activeLockCount(), this.statement::getHits, this.statement::getFaults, threadId, threadName, this.clock, this.cpuClockRef.get());
        this.registerExecutingQuery(executingQuery);
        return executingQuery;
    }

    @Override
    public void unregisterExecutingQuery(ExecutingQuery executingQuery) {
        this.statement.stopQueryExecution(executingQuery);
    }
}

