/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.Flushable;
import java.nio.ByteBuffer;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;

public class ByteBufferFlushableChannel
implements FlushableChannel,
Flushable {
    private final ByteBuffer buffer;

    public ByteBufferFlushableChannel(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public Flushable prepareForFlush() {
        return this;
    }

    @Override
    public FlushableChannel put(byte value) {
        this.buffer.put(value);
        return this;
    }

    @Override
    public FlushableChannel putShort(short value) {
        this.buffer.putShort(value);
        return this;
    }

    @Override
    public FlushableChannel putInt(int value) {
        this.buffer.putInt(value);
        return this;
    }

    @Override
    public FlushableChannel putLong(long value) {
        this.buffer.putLong(value);
        return this;
    }

    @Override
    public FlushableChannel putFloat(float value) {
        this.buffer.putFloat(value);
        return this;
    }

    @Override
    public FlushableChannel putDouble(double value) {
        this.buffer.putDouble(value);
        return this;
    }

    @Override
    public FlushableChannel put(byte[] value, int length) {
        this.buffer.put(value, 0, length);
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }
}

