/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.function.LongFunction;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;

class NodeInputIdPropertyLookup
implements LongFunction<Object> {
    private final PropertyStore propertyStore;
    private final PropertyRecord propertyRecord;

    NodeInputIdPropertyLookup(PropertyStore propertyStore) {
        this.propertyStore = propertyStore;
        this.propertyRecord = propertyStore.newRecord();
    }

    @Override
    public Object apply(long nodeId) {
        this.propertyStore.getRecord(nodeId, this.propertyRecord, RecordLoad.CHECK);
        if (!this.propertyRecord.inUse()) {
            return null;
        }
        return this.propertyRecord.iterator().next().newPropertyValue(this.propertyStore).asObject();
    }
}

