/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.neo4j.helpers.Numbers;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.impl.util.collection.OffHeapBlockAllocator;
import org.neo4j.memory.MemoryAllocationTracker;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;
import org.neo4j.util.Preconditions;
import org.neo4j.util.VisibleForTesting;

public class CachingOffHeapBlockAllocator
implements OffHeapBlockAllocator {
    private final long maxCacheableBlockSize;
    private volatile boolean released;
    private final BlockingQueue<OffHeapBlockAllocator.MemoryBlock>[] caches;

    @VisibleForTesting
    public CachingOffHeapBlockAllocator() {
        this(ByteUnit.kibiBytes((long)512L), 128);
    }

    public CachingOffHeapBlockAllocator(long maxCacheableBlockSize, int maxCachedBlocks) {
        Preconditions.requirePositive((int)maxCachedBlocks);
        this.maxCacheableBlockSize = Preconditions.requirePowerOfTwo((long)maxCacheableBlockSize);
        int numOfCaches = Numbers.log2floor((long)maxCacheableBlockSize) + 1;
        this.caches = new BlockingQueue[numOfCaches];
        for (int i = 0; i < this.caches.length; ++i) {
            this.caches[i] = new ArrayBlockingQueue<OffHeapBlockAllocator.MemoryBlock>(maxCachedBlocks);
        }
    }

    @Override
    public OffHeapBlockAllocator.MemoryBlock allocate(long size, MemoryAllocationTracker tracker) {
        Preconditions.requirePositive((long)size);
        Preconditions.checkState((!this.released ? 1 : 0) != 0, (String)"Allocator is already released");
        if (!this.isCacheable(size)) {
            return this.allocateNew(size, tracker);
        }
        BlockingQueue<OffHeapBlockAllocator.MemoryBlock> cache = this.caches[Numbers.log2floor((long)size)];
        OffHeapBlockAllocator.MemoryBlock block = (OffHeapBlockAllocator.MemoryBlock)cache.poll();
        if (block == null) {
            block = this.allocateNew(size, tracker);
        } else {
            tracker.allocated(block.unalignedSize);
        }
        return block;
    }

    @Override
    public void free(OffHeapBlockAllocator.MemoryBlock block, MemoryAllocationTracker tracker) {
        if (this.released || !this.isCacheable(block.size)) {
            this.doFree(block, tracker);
            return;
        }
        BlockingQueue<OffHeapBlockAllocator.MemoryBlock> cache = this.caches[Numbers.log2floor((long)block.size)];
        if (!cache.offer(block)) {
            this.doFree(block, tracker);
            return;
        }
        if (this.released && cache.remove(block)) {
            this.doFree(block, tracker);
            return;
        }
        tracker.deallocated(block.unalignedSize);
    }

    @Override
    public void release() {
        this.released = true;
        ArrayList blocks = new ArrayList();
        for (BlockingQueue<OffHeapBlockAllocator.MemoryBlock> cache : this.caches) {
            cache.drainTo(blocks);
            blocks.forEach(block -> UnsafeUtil.free((long)block.unalignedAddr, (long)block.unalignedSize));
            blocks.clear();
        }
    }

    @VisibleForTesting
    void doFree(OffHeapBlockAllocator.MemoryBlock block, MemoryAllocationTracker tracker) {
        UnsafeUtil.free((long)block.unalignedAddr, (long)block.unalignedSize, (MemoryAllocationTracker)tracker);
    }

    @VisibleForTesting
    OffHeapBlockAllocator.MemoryBlock allocateNew(long size, MemoryAllocationTracker tracker) {
        long unalignedSize = Preconditions.requirePositive((long)size) + 8L - 1L;
        long unalignedAddr = UnsafeUtil.allocateMemory((long)unalignedSize, (MemoryAllocationTracker)tracker);
        long addr = UnsafeUtil.alignedMemory((long)unalignedAddr, (int)8);
        return new OffHeapBlockAllocator.MemoryBlock(addr, size, unalignedAddr, unalignedSize);
    }

    private boolean isCacheable(long size) {
        return Numbers.isPowerOfTwo((long)size) && size <= this.maxCacheableBlockSize;
    }
}

