/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.lang.reflect.Type;
import java.util.function.Function;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.kernel.impl.proc.ParseUtil;

public class ListConverter
implements Function<String, DefaultParameterValue> {
    private final Type type;
    private final Neo4jTypes.AnyType neoType;

    public ListConverter(Type type, Neo4jTypes.AnyType neoType) {
        this.type = type;
        this.neoType = neoType;
    }

    @Override
    public DefaultParameterValue apply(String s) {
        String value = s.trim();
        if (value.equalsIgnoreCase("null")) {
            return DefaultParameterValue.ntList(null, (Neo4jTypes.AnyType)this.neoType);
        }
        return DefaultParameterValue.ntList(ParseUtil.parseList(value, this.type), (Neo4jTypes.AnyType)this.neoType);
    }
}

