/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query.clientconnection;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;

public class HttpConnectionInfo
extends ClientConnectionInfo {
    private final String connectionId;
    private final String protocol;
    private final SocketAddress clientAddress;
    private final SocketAddress serverAddress;
    private final String requestPath;

    public HttpConnectionInfo(String connectionId, String protocol, SocketAddress clientAddress, SocketAddress serverAddress, String requestPath) {
        this.connectionId = connectionId;
        this.protocol = protocol;
        this.clientAddress = clientAddress;
        this.serverAddress = serverAddress;
        this.requestPath = requestPath;
    }

    @Override
    public String asConnectionDetails() {
        return String.join((CharSequence)"\t", "server-session", this.protocol, HttpConnectionInfo.getHostString(this.clientAddress), this.requestPath);
    }

    @Override
    public String protocol() {
        return this.protocol;
    }

    @Override
    public String connectionId() {
        return this.connectionId;
    }

    @Override
    public String clientAddress() {
        return org.neo4j.helpers.SocketAddress.format(this.clientAddress);
    }

    @Override
    public String requestURI() {
        return this.serverAddress == null ? this.requestPath : this.protocol + "://" + org.neo4j.helpers.SocketAddress.format(this.serverAddress) + this.requestPath;
    }

    private static String getHostString(SocketAddress address) {
        return address instanceof InetSocketAddress ? ((InetSocketAddress)address).getHostString() : address.toString();
    }
}

