/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.io.IOException;
import java.util.function.Supplier;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.SilentTokenNameLookup;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.index.NodePropertyAccessor;
import org.neo4j.kernel.api.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.schema.IndexDescriptor;

public class ConstraintIndexCreator {
    private final IndexingService indexingService;
    private final Supplier<Kernel> kernelSupplier;
    private final NodePropertyAccessor nodePropertyAccessor;
    private final Log log;

    public ConstraintIndexCreator(Supplier<Kernel> kernelSupplier, IndexingService indexingService, NodePropertyAccessor nodePropertyAccessor, LogProvider logProvider) {
        this.kernelSupplier = kernelSupplier;
        this.indexingService = indexingService;
        this.nodePropertyAccessor = nodePropertyAccessor;
        this.log = logProvider.getLog(ConstraintIndexCreator.class);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long createUniquenessConstraintIndex(KernelTransactionImplementation transaction, SchemaDescriptor descriptor, String provider) throws TransactionFailureException, CreateConstraintFailureException, UniquePropertyValueValidationException, AlreadyConstrainedException {
        long l;
        block14: {
            IndexReference index;
            SchemaRead schemaRead;
            block15: {
                UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForSchema(descriptor);
                this.log.info("Starting constraint creation: %s.", new Object[]{constraint.ownedIndexDescriptor()});
                schemaRead = transaction.schemaRead();
                try {
                    index = this.getOrCreateUniquenessConstraintIndex(schemaRead, transaction.tokenRead(), descriptor, provider);
                }
                catch (AlreadyConstrainedException e) {
                    throw e;
                }
                catch (IndexNotFoundKernelException | SchemaKernelException e) {
                    throw new CreateConstraintFailureException((ConstraintDescriptor)constraint, e);
                }
                boolean success = false;
                boolean reacquiredLabelLock = false;
                Locks.Client locks = transaction.statementLocks().pessimistic();
                try {
                    long indexId = schemaRead.indexGetCommittedId(index);
                    IndexProxy proxy = this.indexingService.getIndexProxy(indexId);
                    locks.releaseExclusive(descriptor.keyType(), descriptor.keyId());
                    this.awaitConstrainIndexPopulation(constraint, proxy);
                    this.log.info("Constraint %s populated, starting verification.", new Object[]{constraint.ownedIndexDescriptor()});
                    locks.acquireExclusive(transaction.lockTracer(), descriptor.keyType(), descriptor.keyId());
                    reacquiredLabelLock = true;
                    this.indexingService.getIndexProxy(indexId).verifyDeferredConstraints(this.nodePropertyAccessor);
                    this.log.info("Constraint %s verified.", new Object[]{constraint.ownedIndexDescriptor()});
                    success = true;
                    l = indexId;
                    if (success) break block14;
                    if (reacquiredLabelLock) break block15;
                }
                catch (SchemaKernelException e) {
                    try {
                        throw new IllegalStateException(String.format("Index (%s) that we just created does not exist.", descriptor), e);
                        catch (IndexNotFoundKernelException e2) {
                            throw new TransactionFailureException(String.format("Index (%s) that we just created does not exist.", descriptor), (Throwable)e2);
                        }
                        catch (IndexEntryConflictException e3) {
                            throw new UniquePropertyValueValidationException((IndexBackedConstraintDescriptor)constraint, ConstraintValidationException.Phase.VERIFICATION, e3);
                        }
                        catch (IOException | InterruptedException e4) {
                            throw new CreateConstraintFailureException((ConstraintDescriptor)constraint, (Throwable)e4);
                        }
                    }
                    catch (Throwable throwable) {
                        if (!success) {
                            if (!reacquiredLabelLock) {
                                locks.acquireExclusive(transaction.lockTracer(), descriptor.keyType(), descriptor.keyId());
                            }
                            if (this.indexStillExists(schemaRead, descriptor, index)) {
                                this.dropUniquenessConstraintIndex((IndexDescriptor)index);
                            }
                        }
                        throw throwable;
                    }
                }
                locks.acquireExclusive(transaction.lockTracer(), descriptor.keyType(), descriptor.keyId());
            }
            if (this.indexStillExists(schemaRead, descriptor, index)) {
                this.dropUniquenessConstraintIndex((IndexDescriptor)index);
            }
        }
        return l;
    }

    private boolean indexStillExists(SchemaRead schemaRead, SchemaDescriptor descriptor, IndexReference index) {
        IndexReference existingIndex = schemaRead.index(descriptor);
        return existingIndex != IndexReference.NO_INDEX && existingIndex.equals(index);
    }

    public void dropUniquenessConstraintIndex(IndexDescriptor descriptor) throws TransactionFailureException {
        try (Transaction transaction = this.kernelSupplier.get().beginTransaction(Transaction.Type.implicit, (LoginContext)SecurityContext.AUTH_DISABLED);
             Statement ignore = ((KernelTransaction)transaction).acquireStatement();){
            ((KernelTransactionImplementation)transaction).txState().indexDoDrop(descriptor);
            transaction.success();
        }
    }

    private void awaitConstrainIndexPopulation(UniquenessConstraintDescriptor constraint, IndexProxy proxy) throws InterruptedException, UniquePropertyValueValidationException {
        try {
            proxy.awaitStoreScanCompleted();
        }
        catch (IndexPopulationFailedKernelException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IndexEntryConflictException) {
                throw new UniquePropertyValueValidationException((IndexBackedConstraintDescriptor)constraint, ConstraintValidationException.Phase.VERIFICATION, (IndexEntryConflictException)cause);
            }
            throw new UniquePropertyValueValidationException((IndexBackedConstraintDescriptor)constraint, ConstraintValidationException.Phase.VERIFICATION, (Throwable)((Object)e));
        }
    }

    private IndexReference getOrCreateUniquenessConstraintIndex(SchemaRead schemaRead, TokenRead tokenRead, SchemaDescriptor schema, String provider) throws SchemaKernelException, IndexNotFoundKernelException {
        IndexReference descriptor = schemaRead.index(schema);
        if (descriptor != IndexReference.NO_INDEX) {
            if (descriptor.isUnique()) {
                if (schemaRead.indexGetOwningUniquenessConstraintId(descriptor) == null) {
                    return descriptor;
                }
                throw new AlreadyConstrainedException(ConstraintDescriptorFactory.uniqueForSchema(schema), SchemaKernelException.OperationContext.CONSTRAINT_CREATION, new SilentTokenNameLookup(tokenRead));
            }
            throw new AlreadyIndexedException(schema, SchemaKernelException.OperationContext.CONSTRAINT_CREATION);
        }
        IndexDescriptor indexDescriptor = this.createConstraintIndex(schema, provider);
        IndexProxy indexProxy = this.indexingService.getIndexProxy(indexDescriptor.schema());
        return indexProxy.getDescriptor();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IndexDescriptor createConstraintIndex(SchemaDescriptor schema, String provider) {
        try (Transaction transaction = this.kernelSupplier.get().beginTransaction(Transaction.Type.implicit, (LoginContext)SecurityContext.AUTH_DISABLED);){
            IndexDescriptor index = ((KernelTransaction)transaction).indexUniqueCreate(schema, provider);
            transaction.success();
            IndexDescriptor indexDescriptor = index;
            return indexDescriptor;
        }
        catch (TransactionFailureException e) {
            throw new RuntimeException(e);
        }
    }
}

