/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.security;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.security.exception.InvalidAuthTokenException;
import org.neo4j.string.UTF8;

public interface AuthToken {
    public static final String SCHEME_KEY = "scheme";
    public static final String PRINCIPAL = "principal";
    public static final String CREDENTIALS = "credentials";
    public static final String REALM_KEY = "realm";
    public static final String PARAMETERS = "parameters";
    public static final String NEW_CREDENTIALS = "new_credentials";
    public static final String BASIC_SCHEME = "basic";
    public static final String NATIVE_REALM = "native";

    public static String safeCast(String key, Map<String, Object> authToken) throws InvalidAuthTokenException {
        Object value = authToken.get(key);
        if (value == null) {
            throw AuthToken.invalidToken("missing key `" + key + "`");
        }
        if (!(value instanceof String)) {
            throw AuthToken.invalidToken("the value associated with the key `" + key + "` must be a String but was: " + value.getClass().getSimpleName());
        }
        return (String)value;
    }

    public static byte[] safeCastCredentials(String key, Map<String, Object> authToken) throws InvalidAuthTokenException {
        Object value = authToken.get(key);
        if (value == null) {
            throw AuthToken.invalidToken("missing key `" + key + "`");
        }
        if (!(value instanceof byte[])) {
            throw AuthToken.invalidToken("the value associated with the key `" + key + "` must be a byte[] but was: " + value.getClass().getSimpleName());
        }
        return (byte[])value;
    }

    public static Map<String, Object> safeCastMap(String key, Map<String, Object> authToken) throws InvalidAuthTokenException {
        Object value = authToken.get(key);
        if (value == null) {
            return Collections.emptyMap();
        }
        if (value instanceof Map) {
            return (Map)value;
        }
        throw new InvalidAuthTokenException("The value associated with the key `" + key + "` must be a Map but was: " + value.getClass().getSimpleName());
    }

    public static boolean containsSensitiveInformation(String key) {
        return CREDENTIALS.equals(key) || NEW_CREDENTIALS.equals(key);
    }

    public static void clearCredentials(Map<String, Object> authToken) {
        Object newCredentials;
        Object credentials = authToken.get(CREDENTIALS);
        if (credentials instanceof byte[]) {
            Arrays.fill((byte[])credentials, (byte)0);
        }
        if ((newCredentials = authToken.get(NEW_CREDENTIALS)) instanceof byte[]) {
            Arrays.fill((byte[])newCredentials, (byte)0);
        }
    }

    public static InvalidAuthTokenException invalidToken(String explanation) {
        if (StringUtils.isNotEmpty((CharSequence)explanation) && !explanation.matches("^[,.:;].*")) {
            explanation = ", " + explanation;
        }
        return new InvalidAuthTokenException(String.format("Unsupported authentication token%s", explanation));
    }

    public static Map<String, Object> newBasicAuthToken(String username, byte[] password) {
        return MapUtil.map((Object[])new Object[]{SCHEME_KEY, BASIC_SCHEME, PRINCIPAL, username, CREDENTIALS, password});
    }

    public static Map<String, Object> newBasicAuthToken(String username, byte[] password, String realm) {
        return MapUtil.map((Object[])new Object[]{SCHEME_KEY, BASIC_SCHEME, PRINCIPAL, username, CREDENTIALS, password, REALM_KEY, realm});
    }

    public static Map<String, Object> newCustomAuthToken(String principle, byte[] credentials, String realm, String scheme) {
        return MapUtil.map((Object[])new Object[]{SCHEME_KEY, scheme, PRINCIPAL, principle, CREDENTIALS, credentials, REALM_KEY, realm});
    }

    public static Map<String, Object> newCustomAuthToken(String principle, byte[] credentials, String realm, String scheme, Map<String, Object> parameters) {
        return MapUtil.map((Object[])new Object[]{SCHEME_KEY, scheme, PRINCIPAL, principle, CREDENTIALS, credentials, REALM_KEY, realm, PARAMETERS, parameters});
    }

    public static Map<String, Object> newBasicAuthToken(String username, String password) {
        return AuthToken.newBasicAuthToken(username, UTF8.encode((String)password));
    }

    public static Map<String, Object> newBasicAuthToken(String username, String password, String realm) {
        return AuthToken.newBasicAuthToken(username, UTF8.encode((String)password), realm);
    }

    public static Map<String, Object> newCustomAuthToken(String principle, String credentials, String realm, String scheme) {
        return AuthToken.newCustomAuthToken(principle, UTF8.encode((String)credentials), realm, scheme);
    }

    public static Map<String, Object> newCustomAuthToken(String principle, String credentials, String realm, String scheme, Map<String, Object> parameters) {
        return AuthToken.newCustomAuthToken(principle, UTF8.encode((String)credentials), realm, scheme, parameters);
    }
}

