/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query.clientconnection;

import java.net.InetSocketAddress;
import org.neo4j.helpers.SocketAddress;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;

public class HttpConnectionInfo
extends ClientConnectionInfo {
    private final String protocol;
    private final InetSocketAddress clientAddress;
    private final InetSocketAddress serverAddress;
    private final String requestPath;

    public HttpConnectionInfo(String protocol, String userAgent, InetSocketAddress clientAddress, InetSocketAddress serverAddress, String requestPath) {
        this.protocol = protocol;
        this.clientAddress = clientAddress;
        this.serverAddress = serverAddress;
        this.requestPath = requestPath;
    }

    @Override
    public String asConnectionDetails() {
        return String.join((CharSequence)"\t", "server-session", this.protocol, this.clientAddress.getHostString(), this.requestPath);
    }

    @Override
    public String protocol() {
        return this.protocol;
    }

    @Override
    public String clientAddress() {
        return SocketAddress.format(this.clientAddress);
    }

    @Override
    public String requestURI() {
        return this.serverAddress == null ? this.requestPath : this.protocol + "://" + SocketAddress.format(this.serverAddress) + this.requestPath;
    }
}

