/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.StringIndexKey;
import org.neo4j.kernel.impl.index.schema.StringLayout;
import org.neo4j.kernel.impl.index.schema.Type;
import org.neo4j.kernel.impl.index.schema.Types;
import org.neo4j.values.storable.UTF8StringValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

class TextType
extends Type {
    static final long CHAR_TYPE_STATE_MARKER = 2L;
    static final int CHAR_TYPE_LENGTH_MARKER = 32768;

    TextType(byte typeId) {
        super(ValueGroup.TEXT, typeId, Values.of((Object)""), Values.of((Object)""));
    }

    @Override
    int valueSize(GenericKey state) {
        return TextType.textKeySize(state.long0);
    }

    @Override
    void copyValue(GenericKey to, GenericKey from) {
        to.long0 = from.long0;
        to.long1 = from.long1;
        to.long2 = from.long2;
        to.long3 = from.long3;
        TextType.setBytesLength(to, (int)from.long0);
        System.arraycopy(from.byteArray, 0, to.byteArray, 0, (int)from.long0);
    }

    @Override
    void minimalSplitter(GenericKey left, GenericKey right, GenericKey into) {
        int length = 0;
        if (left.type == Types.TEXT) {
            length = StringLayout.minimalLengthFromRightNeededToDifferentiateFromLeft(left.byteArray, (int)left.long0, right.byteArray, (int)right.long0);
        }
        into.writeUTF8(right.byteArray, 0, length);
    }

    @Override
    Value asValue(GenericKey state) {
        if (state.byteArray == null) {
            return Values.NO_VALUE;
        }
        if (TextType.isCharValueType(state.long2)) {
            return Values.charValue((char)TextType.textAsChar(state.byteArray));
        }
        state.long1 = 1L;
        return Values.utf8Value((byte[])state.byteArray, (int)0, (int)((int)state.long0));
    }

    @Override
    int compareValue(GenericKey left, GenericKey right) {
        return TextType.compare(left.byteArray, left.long0, left.long2, left.long3, right.byteArray, right.long0, right.long2, right.long3);
    }

    @Override
    void putValue(PageCursor cursor, GenericKey state) {
        TextType.put(cursor, state.byteArray, state.long0, state.long2);
    }

    @Override
    boolean readValue(PageCursor cursor, int size, GenericKey into) {
        return TextType.read(cursor, size, into);
    }

    static int textKeySize(long long0) {
        return 2 + (int)long0;
    }

    static int compare(byte[] this_byteArray, long this_long0, long this_long2, long this_long3, byte[] that_byteArray, long that_long0, long that_long2, long that_long3) {
        if (this_byteArray != that_byteArray) {
            if (TextType.isHighestText(this_long3) || TextType.isHighestText(that_long3)) {
                return Boolean.compare(TextType.isHighestText(this_long3), TextType.isHighestText(that_long3));
            }
            if (this_byteArray == null) {
                return -1;
            }
            if (that_byteArray == null) {
                return 1;
            }
        } else {
            return 0;
        }
        return StringIndexKey.lexicographicalUnsignedByteArrayCompare(this_byteArray, (int)this_long0, that_byteArray, (int)that_long0, TextType.booleanOf(this_long2) | TextType.booleanOf(that_long2));
    }

    static void put(PageCursor cursor, byte[] byteArray, long long0, long long2) {
        short length = GenericKey.toNonNegativeShortExact(long0);
        cursor.putShort(TextType.isCharValueType(long2) ? (short)(length | 0x8000) : length);
        cursor.putBytes(byteArray, 0, (int)length);
    }

    static boolean read(PageCursor cursor, int maxSize, GenericKey into) {
        short rawLength = cursor.getShort();
        boolean isCharType = (rawLength & 0x8000) != 0;
        short bytesLength = (short)(rawLength & 0xFFFF7FFF);
        if (bytesLength < 0 || bytesLength > maxSize) {
            GenericKey.setCursorException(cursor, "non-valid bytes length for text, " + bytesLength);
            return false;
        }
        TextType.setCharType(into, isCharType);
        TextType.setBytesLength(into, bytesLength);
        cursor.getBytes(into.byteArray, 0, (int)bytesLength);
        return true;
    }

    static void setCharType(GenericKey into, boolean isCharType) {
        into.long2 = isCharType ? (into.long2 |= 2L) : (into.long2 &= 0xFFFFFFFFFFFFFFFDL);
    }

    private static boolean isHighestText(long long3) {
        return long3 == 1L;
    }

    static boolean isCharValueType(long long2) {
        return TextType.booleanOf(long2 >> 1);
    }

    void write(GenericKey state, byte[] bytes, boolean isCharType) {
        state.byteArray = bytes;
        state.long0 = bytes.length;
        TextType.setCharType(state, isCharType);
    }

    @Override
    void initializeAsHighest(GenericKey state) {
        super.initializeAsHighest(state);
        state.long3 = 1L;
    }

    static char textAsChar(byte[] byteArray) {
        long codePoint = new UTF8StringValue.CodePointCursor(byteArray, 0).nextCodePoint();
        if ((codePoint & 0xFFFFFFFFFFFF0000L) != 0L) {
            throw new IllegalStateException("Char value seems to be bigger than what a char can hold " + codePoint);
        }
        return (char)codePoint;
    }

    private static void setBytesLength(GenericKey state, int length) {
        if (TextType.booleanOf(state.long1) || state.byteArray == null || state.byteArray.length < length) {
            state.long1 = 0L;
            state.byteArray = new byte[length + length / 2];
        }
        state.long0 = length;
    }
}

