/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.updater;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.util.diffsets.MutableLongDiffSets;
import org.neo4j.kernel.impl.util.diffsets.MutableLongDiffSetsImpl;

public abstract class UniquePropertyIndexUpdater
implements IndexUpdater {
    private final Map<Object, MutableLongDiffSets> referenceCount = new HashMap<Object, MutableLongDiffSets>();
    private final ArrayList<IndexEntryUpdate<?>> updates = new ArrayList();

    @Override
    public void process(IndexEntryUpdate<?> update) {
        switch (update.updateMode()) {
            case ADDED: {
                this.propertyValueDiffSet(update.values()).add(update.getEntityId());
                break;
            }
            case CHANGED: {
                this.propertyValueDiffSet(update.beforeValues()).remove(update.getEntityId());
                this.propertyValueDiffSet(update.values()).add(update.getEntityId());
                break;
            }
            case REMOVED: {
                this.propertyValueDiffSet(update.values()).remove(update.getEntityId());
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.updates.add(update);
    }

    @Override
    public void close() {
        this.flushUpdates(this.updates);
    }

    protected abstract void flushUpdates(Iterable<IndexEntryUpdate<?>> var1);

    private MutableLongDiffSets propertyValueDiffSet(Object value) {
        return this.referenceCount.computeIfAbsent(value, k -> new MutableLongDiffSetsImpl());
    }
}

