/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.diffsets;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.kernel.impl.util.collection.CollectionsFactory;
import org.neo4j.kernel.impl.util.collection.OnHeapCollectionsFactory;
import org.neo4j.kernel.impl.util.diffsets.DiffApplyingPrimitiveLongIterator;
import org.neo4j.kernel.impl.util.diffsets.MutableLongDiffSets;

public class MutableLongDiffSetsImpl
implements MutableLongDiffSets {
    private static final MutableLongSet NOT_INITIALIZED = LongSets.mutable.empty().asUnmodifiable();
    private final CollectionsFactory collectionsFactory;
    private MutableLongSet added;
    private MutableLongSet removed;

    public MutableLongDiffSetsImpl() {
        this(NOT_INITIALIZED, NOT_INITIALIZED, OnHeapCollectionsFactory.INSTANCE);
    }

    public MutableLongDiffSetsImpl(MutableLongSet added, MutableLongSet removed, CollectionsFactory collectionsFactory) {
        this.added = added;
        this.removed = removed;
        this.collectionsFactory = collectionsFactory;
    }

    public MutableLongDiffSetsImpl(CollectionsFactory collectionsFactory) {
        this(NOT_INITIALIZED, NOT_INITIALIZED, collectionsFactory);
    }

    public boolean isAdded(long element) {
        return this.added.contains(element);
    }

    public boolean isRemoved(long element) {
        return this.removed.contains(element);
    }

    @Override
    public void removeAll(LongIterable elements) {
        this.checkRemovedElements();
        elements.each(this::removeElement);
    }

    @Override
    public void addAll(LongIterable elements) {
        this.checkAddedElements();
        elements.each(this::addElement);
    }

    @Override
    public void add(long element) {
        this.checkAddedElements();
        this.addElement(element);
    }

    @Override
    public boolean remove(long element) {
        this.checkRemovedElements();
        return this.removeElement(element);
    }

    public LongIterator augment(LongIterator source) {
        return DiffApplyingPrimitiveLongIterator.augment(source, (LongSet)this.added, (LongSet)this.removed);
    }

    public PrimitiveLongResourceIterator augment(PrimitiveLongResourceIterator source) {
        return DiffApplyingPrimitiveLongIterator.augment(source, (LongSet)this.added, (LongSet)this.removed);
    }

    public int delta() {
        return this.added.size() - this.removed.size();
    }

    public LongSet getAdded() {
        return this.added;
    }

    public LongSet getRemoved() {
        return this.removed;
    }

    public boolean isEmpty() {
        return this.added.isEmpty() && this.removed.isEmpty();
    }

    private void addElement(long element) {
        if (this.removed.isEmpty() || !this.removed.remove(element)) {
            this.added.add(element);
        }
    }

    private boolean removeElement(long element) {
        if (!this.added.isEmpty() && this.added.remove(element)) {
            return true;
        }
        return this.removed.add(element);
    }

    private void checkAddedElements() {
        if (this.added == NOT_INITIALIZED) {
            this.added = this.collectionsFactory.newLongSet();
        }
    }

    private void checkRemovedElements() {
        if (this.removed == NOT_INITIALIZED) {
            this.removed = this.collectionsFactory.newLongSet();
        }
    }
}

