/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.IndexLimitation;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.IndexValueCapability;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.values.storable.ValueCategory;

public class KernelIndexAugmentation {
    private static boolean isNativeBTree(String key, String version) {
        return GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerName().equals(key) && GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerVersion().equals(version);
    }

    public static IndexCapability augmentIndexCapability(final IndexCapability capability, IndexProviderDescriptor providerDescriptor) {
        if (KernelIndexAugmentation.isNativeBTree(providerDescriptor.getKey(), providerDescriptor.getVersion())) {
            return new IndexCapability(){

                public IndexOrder[] orderCapability(ValueCategory ... valueCategories) {
                    return capability.orderCapability(valueCategories);
                }

                public IndexValueCapability valueCapability(ValueCategory ... valueCategories) {
                    return IndexValueCapability.YES;
                }

                public IndexLimitation[] limitations() {
                    return capability.limitations();
                }
            };
        }
        return capability;
    }

    public static boolean shouldInjectValues(IndexReference index, boolean needsValues) {
        return needsValues && KernelIndexAugmentation.isNativeBTree(index.providerKey(), index.providerVersion());
    }
}

