/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.AbstractArrayType;
import org.neo4j.kernel.impl.index.schema.GenericKeyState;
import org.neo4j.kernel.impl.index.schema.NumberType;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

class NumberArrayType
extends AbstractArrayType<Number> {
    NumberArrayType(byte typeId) {
        super(ValueGroup.NUMBER_ARRAY, typeId, (o1, o2, i) -> NumberType.compare(o1.long0Array[i], o1.long1, o2.long0Array[i], o2.long1), null, null, null, null, null);
    }

    @Override
    int valueSize(GenericKeyState state) {
        return this.arrayKeySize(state, NumberType.numberKeySize(state.long1)) + 1;
    }

    @Override
    void copyValue(GenericKeyState to, GenericKeyState from, int length) {
        to.long1 = from.long1;
        this.initializeArray(to, length);
        System.arraycopy(from.long0Array, 0, to.long0Array, 0, length);
    }

    @Override
    void initializeArray(GenericKeyState key, int length, ValueWriter.ArrayType arrayType) {
        this.initializeArray(key, length);
        switch (arrayType) {
            case BYTE: {
                key.long1 = 0L;
                break;
            }
            case SHORT: {
                key.long1 = 1L;
                break;
            }
            case INT: {
                key.long1 = 2L;
                break;
            }
            case LONG: {
                key.long1 = 3L;
                break;
            }
            case FLOAT: {
                key.long1 = 4L;
                break;
            }
            case DOUBLE: {
                key.long1 = 5L;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid number array type " + arrayType);
            }
        }
    }

    private void initializeArray(GenericKeyState key, int length) {
        key.long0Array = NumberArrayType.ensureBigEnough(key.long0Array, length);
    }

    @Override
    Value asValue(GenericKeyState state) {
        byte numberType = (byte)state.long1;
        switch (numberType) {
            case 0: {
                byte[] byteArray = new byte[state.arrayLength];
                for (int i = 0; i < state.arrayLength; ++i) {
                    byteArray[i] = (byte)state.long0Array[i];
                }
                return Values.byteArray((byte[])byteArray);
            }
            case 1: {
                short[] shortArray = new short[state.arrayLength];
                for (int i = 0; i < state.arrayLength; ++i) {
                    shortArray[i] = (short)state.long0Array[i];
                }
                return Values.shortArray((short[])shortArray);
            }
            case 2: {
                int[] intArray = new int[state.arrayLength];
                for (int i = 0; i < state.arrayLength; ++i) {
                    intArray[i] = (int)state.long0Array[i];
                }
                return Values.intArray((int[])intArray);
            }
            case 3: {
                return Values.longArray((long[])Arrays.copyOf(state.long0Array, state.arrayLength));
            }
            case 4: {
                float[] floatArray = new float[state.arrayLength];
                for (int i = 0; i < state.arrayLength; ++i) {
                    floatArray[i] = Float.intBitsToFloat((int)state.long0Array[i]);
                }
                return Values.floatArray((float[])floatArray);
            }
            case 5: {
                double[] doubleArray = new double[state.arrayLength];
                for (int i = 0; i < state.arrayLength; ++i) {
                    doubleArray[i] = Double.longBitsToDouble(state.long0Array[i]);
                }
                return Values.doubleArray((double[])doubleArray);
            }
        }
        throw new IllegalArgumentException("Unknown number type " + numberType);
    }

    @Override
    void putValue(PageCursor cursor, GenericKeyState state) {
        cursor.putByte((byte)state.long1);
        NumberArrayType.putArray(cursor, state, this.numberArrayElementWriter(state));
    }

    private AbstractArrayType.ArrayElementWriter numberArrayElementWriter(GenericKeyState key) {
        switch ((int)key.long1) {
            case 0: {
                return (c, k, i) -> c.putByte((byte)k.long0Array[i]);
            }
            case 1: {
                return (c, k, i) -> c.putShort((short)k.long0Array[i]);
            }
            case 2: 
            case 4: {
                return (c, k, i) -> c.putInt((int)k.long0Array[i]);
            }
            case 3: 
            case 5: {
                return (c, k, i) -> c.putLong(k.long0Array[i]);
            }
        }
        throw new IllegalArgumentException("Unknown number type " + key.long1);
    }

    @Override
    boolean readValue(PageCursor cursor, int size, GenericKeyState into) {
        into.long1 = cursor.getByte();
        ValueWriter.ArrayType numberType = NumberArrayType.numberArrayTypeOf((byte)into.long1);
        if (numberType == null) {
            GenericKeyState.setCursorException(cursor, "non-valid number type for array, " + into.long1);
            return false;
        }
        return NumberArrayType.readArray(cursor, numberType, this.numberArrayElementReader(into), into);
    }

    @Override
    void initializeAsLowest(GenericKeyState state) {
        state.initializeArrayMeta(0);
        this.initializeArray(state, 0, ValueWriter.ArrayType.BYTE);
    }

    @Override
    void initializeAsHighest(GenericKeyState state) {
        state.initializeArrayMeta(0);
        this.initializeArray(state, 0, ValueWriter.ArrayType.BYTE);
        state.isHighestArray = true;
    }

    private static ValueWriter.ArrayType numberArrayTypeOf(byte numberType) {
        switch (numberType) {
            case 0: {
                return ValueWriter.ArrayType.BYTE;
            }
            case 1: {
                return ValueWriter.ArrayType.SHORT;
            }
            case 2: {
                return ValueWriter.ArrayType.INT;
            }
            case 3: {
                return ValueWriter.ArrayType.LONG;
            }
            case 4: {
                return ValueWriter.ArrayType.FLOAT;
            }
            case 5: {
                return ValueWriter.ArrayType.DOUBLE;
            }
        }
        return null;
    }

    private AbstractArrayType.ArrayElementReader numberArrayElementReader(GenericKeyState key) {
        switch ((int)key.long1) {
            case 0: {
                return (c, into) -> {
                    key.writeInteger(c.getByte());
                    return true;
                };
            }
            case 1: {
                return (c, into) -> {
                    key.writeInteger(c.getShort());
                    return true;
                };
            }
            case 2: {
                return (c, into) -> {
                    key.writeInteger(c.getInt());
                    return true;
                };
            }
            case 3: {
                return (c, into) -> {
                    key.writeInteger(c.getLong());
                    return true;
                };
            }
            case 4: {
                return (c, into) -> {
                    key.writeFloatingPoint(Float.intBitsToFloat(c.getInt()));
                    return true;
                };
            }
            case 5: {
                return (c, into) -> {
                    key.writeFloatingPoint(Double.longBitsToDouble(c.getLong()));
                    return true;
                };
            }
        }
        throw new IllegalArgumentException("Unknown number type " + key.long1);
    }

    void write(GenericKeyState state, int offset, long value) {
        state.long0Array[offset] = value;
    }
}

