/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.CompositeGenericKey;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettingsCache;

class GenericLayout
extends IndexLayout<CompositeGenericKey, NativeIndexValue> {
    private final int numberOfSlots;
    private final IndexSpecificSpaceFillingCurveSettingsCache spatialSettings;

    GenericLayout(int numberOfSlots, IndexSpecificSpaceFillingCurveSettingsCache spatialSettings) {
        super("NSIL", 0, 3);
        this.numberOfSlots = numberOfSlots;
        this.spatialSettings = spatialSettings;
    }

    public CompositeGenericKey newKey() {
        return new CompositeGenericKey(this.numberOfSlots, this.spatialSettings);
    }

    public CompositeGenericKey copyKey(CompositeGenericKey key, CompositeGenericKey into) {
        into.setEntityId(key.getEntityId());
        into.setCompareId(key.getCompareId());
        into.copyValuesFrom(key);
        return into;
    }

    public int keySize(CompositeGenericKey key) {
        return key.size();
    }

    public void writeKey(PageCursor cursor, CompositeGenericKey key) {
        key.write(cursor);
    }

    public void readKey(PageCursor cursor, CompositeGenericKey into, int keySize) {
        into.read(cursor, keySize);
    }

    @Override
    public boolean fixedSize() {
        return false;
    }

    public void minimalSplitter(CompositeGenericKey left, CompositeGenericKey right, CompositeGenericKey into) {
        CompositeGenericKey.minimalSplitter(left, right, into);
    }

    IndexSpecificSpaceFillingCurveSettingsCache getSpaceFillingCurveSettings() {
        return this.spatialSettings;
    }
}

