/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.AbstractArrayType;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.Type;
import org.neo4j.kernel.impl.index.schema.Types;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.store.TemporalValueWriterAdapter;
import org.neo4j.string.UTF8;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PrimitiveArrayWriting;
import org.neo4j.values.storable.TimeZones;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;

public class GenericKeyState
extends TemporalValueWriterAdapter<RuntimeException> {
    static final int BIGGEST_STATIC_SIZE = 32;
    public static final int SIZE_GEOMETRY_HEADER = 3;
    public static final int SIZE_GEOMETRY = 8;
    public static final int SIZE_ZONED_DATE_TIME = 16;
    public static final int SIZE_LOCAL_DATE_TIME = 12;
    public static final int SIZE_DATE = 8;
    public static final int SIZE_ZONED_TIME = 12;
    public static final int SIZE_LOCAL_TIME = 8;
    public static final int SIZE_DURATION = 28;
    public static final int SIZE_STRING_LENGTH = 2;
    public static final int SIZE_BOOLEAN = 1;
    public static final int SIZE_NUMBER_TYPE = 1;
    public static final int SIZE_NUMBER_BYTE = 1;
    public static final int SIZE_NUMBER_SHORT = 2;
    public static final int SIZE_NUMBER_INT = 4;
    public static final int SIZE_NUMBER_LONG = 8;
    public static final int SIZE_NUMBER_FLOAT = 4;
    public static final int SIZE_NUMBER_DOUBLE = 8;
    public static final int SIZE_ARRAY_LENGTH = 2;
    static final int BIGGEST_REASONABLE_ARRAY_LENGTH = 4096;
    static final long TRUE = 1L;
    static final long FALSE = 0L;
    private static final int TYPE_ID_SIZE = 1;
    private final IndexSpecificSpaceFillingCurveSettingsCache settings;
    Type type;
    NativeIndexKey.Inclusion inclusion;
    private boolean isArray;
    long long0;
    long long1;
    long long2;
    long long3;
    byte[] byteArray;
    long[] long0Array;
    long[] long1Array;
    long[] long2Array;
    long[] long3Array;
    byte[][] byteArrayArray;
    boolean isHighestArray;
    int arrayLength;
    int currentArrayOffset;
    SpaceFillingCurve spaceFillingCurve;

    GenericKeyState(IndexSpecificSpaceFillingCurveSettingsCache settings) {
        this.settings = settings;
    }

    void clear() {
        if (this.type == Types.TEXT && Type.booleanOf(this.long1)) {
            this.byteArray = null;
        }
        this.type = null;
        this.long0 = 0L;
        this.long1 = 0L;
        this.long2 = 0L;
        this.long3 = 0L;
        this.inclusion = NativeIndexKey.Inclusion.NEUTRAL;
        this.isArray = false;
        this.arrayLength = 0;
        this.isHighestArray = false;
        this.currentArrayOffset = 0;
        this.spaceFillingCurve = null;
    }

    void initializeToDummyValue() {
        this.clear();
        this.writeInteger(0);
        this.inclusion = NativeIndexKey.Inclusion.NEUTRAL;
    }

    void initValueAsLowest(ValueGroup valueGroup) {
        this.clear();
        this.type = valueGroup == ValueGroup.UNKNOWN ? Types.LOWEST_BY_VALUE_GROUP : Types.BY_GROUP[valueGroup.ordinal()];
        this.type.initializeAsLowest(this);
    }

    void initValueAsHighest(ValueGroup valueGroup) {
        this.clear();
        this.type = valueGroup == ValueGroup.UNKNOWN ? Types.HIGHEST_BY_VALUE_GROUP : Types.BY_GROUP[valueGroup.ordinal()];
        this.type.initializeAsHighest(this);
    }

    void initAsPrefixLow(String prefix) {
        this.writeString(prefix);
        this.long2 = 0L;
        this.inclusion = NativeIndexKey.Inclusion.LOW;
    }

    void initAsPrefixHigh(String prefix) {
        this.writeString(prefix);
        this.long2 = 1L;
        this.inclusion = NativeIndexKey.Inclusion.HIGH;
    }

    void copyFrom(GenericKeyState key) {
        this.copyMetaFrom(key);
        this.type.copyValue(this, key);
    }

    private void copyMetaFrom(GenericKeyState key) {
        this.type = key.type;
        this.inclusion = key.inclusion;
        this.isArray = key.isArray;
        if (key.isArray) {
            this.arrayLength = key.arrayLength;
            this.currentArrayOffset = key.currentArrayOffset;
            this.isHighestArray = key.isHighestArray;
        }
    }

    void writeValue(Value value, NativeIndexKey.Inclusion inclusion) {
        value.writeTo((ValueWriter)this);
        this.inclusion = inclusion;
    }

    int compareValueTo(GenericKeyState other) {
        if (this.type == null) {
            return -1;
        }
        if (other.type == null) {
            return 1;
        }
        int typeComparison = Type.COMPARATOR.compare(this.type, other.type);
        if (typeComparison != 0) {
            return typeComparison;
        }
        int valueComparison = this.type.compareValue(this, other);
        if (valueComparison != 0) {
            return valueComparison;
        }
        return this.inclusion.compareTo(other.inclusion);
    }

    static void minimalSplitter(GenericKeyState left, GenericKeyState right, GenericKeyState into) {
        into.clear();
        into.copyMetaFrom(right);
        right.type.minimalSplitter(left, right, into);
    }

    int size() {
        return this.type.valueSize(this) + 1;
    }

    Value asValue() {
        return this.type.asValue(this);
    }

    void put(PageCursor cursor) {
        cursor.putByte(this.type.typeId);
        this.type.putValue(cursor, this);
    }

    boolean read(PageCursor cursor, int size) {
        if (size <= 1) {
            GenericKeyState.setCursorException(cursor, "slot size less than TYPE_ID_SIZE, " + size);
            return false;
        }
        byte typeId = cursor.getByte();
        if (typeId < 0 || typeId >= Types.BY_ID.length) {
            GenericKeyState.setCursorException(cursor, "non-valid typeId, " + typeId);
            return false;
        }
        this.type = Types.BY_ID[typeId];
        this.inclusion = NativeIndexKey.Inclusion.NEUTRAL;
        return this.type.readValue(cursor, --size, this);
    }

    private <T extends Type> T setType(T type) {
        this.type = type;
        return type;
    }

    @Override
    protected void writeDate(long epochDay) {
        if (!this.isArray) {
            this.setType(Types.DATE).write(this, epochDay);
        } else {
            Types.DATE_ARRAY.write(this, this.currentArrayOffset++, epochDay);
        }
    }

    @Override
    protected void writeLocalTime(long nanoOfDay) {
        if (!this.isArray) {
            this.setType(Types.LOCAL_TIME).write(this, nanoOfDay);
        } else {
            Types.LOCAL_TIME_ARRAY.write(this, this.currentArrayOffset++, nanoOfDay);
        }
    }

    @Override
    protected void writeTime(long nanosOfDayUTC, int offsetSeconds) {
        if (!this.isArray) {
            this.setType(Types.ZONED_TIME).write(this, nanosOfDayUTC, offsetSeconds);
        } else {
            Types.ZONED_TIME_ARRAY.write(this, this.currentArrayOffset++, nanosOfDayUTC, offsetSeconds);
        }
    }

    @Override
    protected void writeLocalDateTime(long epochSecond, int nano) {
        if (!this.isArray) {
            this.setType(Types.LOCAL_DATE_TIME).write(this, epochSecond, nano);
        } else {
            Types.LOCAL_DATE_TIME_ARRAY.write(this, this.currentArrayOffset++, epochSecond, nano);
        }
    }

    @Override
    protected void writeDateTime(long epochSecondUTC, int nano, int offsetSeconds) {
        this.writeDateTime(epochSecondUTC, nano, (short)-1, offsetSeconds);
    }

    @Override
    protected void writeDateTime(long epochSecondUTC, int nano, String zoneId) {
        this.writeDateTime(epochSecondUTC, nano, TimeZones.map((String)zoneId));
    }

    protected void writeDateTime(long epochSecondUTC, int nano, short zoneId) {
        this.writeDateTime(epochSecondUTC, nano, zoneId, 0);
    }

    private void writeDateTime(long epochSecondUTC, int nano, short zoneId, int offsetSeconds) {
        if (!this.isArray) {
            this.setType(Types.ZONED_DATE_TIME).write(this, epochSecondUTC, nano, zoneId, offsetSeconds);
        } else {
            Types.ZONED_DATE_TIME_ARRAY.write(this, this.currentArrayOffset++, epochSecondUTC, nano, zoneId, offsetSeconds);
        }
    }

    public void writeBoolean(boolean value) {
        if (!this.isArray) {
            this.setType(Types.BOOLEAN).write(this, value);
        } else {
            Types.BOOLEAN_ARRAY.write(this, this.currentArrayOffset++, value);
        }
    }

    private void writeNumber(long value, byte numberType) {
        if (!this.isArray) {
            this.setType(Types.NUMBER).write(this, value, numberType);
        } else {
            Types.NUMBER_ARRAY.write(this, this.currentArrayOffset++, value);
        }
    }

    public void writeInteger(byte value) {
        this.writeNumber(value, (byte)0);
    }

    public void writeInteger(short value) {
        this.writeNumber(value, (byte)1);
    }

    public void writeInteger(int value) {
        this.writeNumber(value, (byte)2);
    }

    static short toNonNegativeShortExact(long value) {
        if ((value & 0xFFFFFFFFFFFF8000L) != 0L) {
            throw new IllegalArgumentException(value + " is bigger than maximum for a signed short (2B) " + Short.MAX_VALUE);
        }
        return (short)value;
    }

    public void writeInteger(long value) {
        this.writeNumber(value, (byte)3);
    }

    public void writeFloatingPoint(float value) {
        this.writeNumber(Float.floatToIntBits(value), (byte)4);
    }

    public void writeFloatingPoint(double value) {
        this.writeNumber(Double.doubleToLongBits(value), (byte)5);
    }

    public void writeString(String value) {
        this.writeStringBytes(UTF8.encode((String)value), false);
    }

    public void writeString(char value) {
        this.writeStringBytes(UTF8.encode((String)String.valueOf(value)), true);
    }

    public void writeUTF8(byte[] bytes, int offset, int length) {
        byte[] dest = new byte[length];
        System.arraycopy(bytes, offset, dest, 0, length);
        this.writeStringBytes(dest, false);
    }

    private void writeStringBytes(byte[] bytes, boolean isCharType) {
        if (!this.isArray) {
            this.setType(Types.TEXT).write(this, bytes, isCharType);
        } else {
            Types.TEXT_ARRAY.write(this, this.currentArrayOffset++, bytes);
        }
        this.long1 = 0L;
    }

    public void writeDuration(long months, long days, long seconds, int nanos) {
        long totalAvgSeconds = months * 2629800L + days * 86400L + seconds;
        this.writeDurationWithTotalAvgSeconds(months, days, totalAvgSeconds, nanos);
    }

    public void writePoint(CoordinateReferenceSystem crs, double[] coordinate) {
        if (!this.isArray) {
            this.updateCurve(crs.getTable().getTableId(), crs.getCode());
            this.setType(Types.GEOMETRY).write(this, this.spaceFillingCurve.derivedValueFor(coordinate));
        } else {
            if (this.currentArrayOffset == 0) {
                this.updateCurve(crs.getTable().getTableId(), crs.getCode());
            } else if (this.long1 != (long)crs.getTable().getTableId() || this.long2 != (long)crs.getCode()) {
                throw new IllegalStateException(String.format("Tried to assign a geometry array containing different coordinate reference systems, first:%s, violating:%s at array position:%d", CoordinateReferenceSystem.get((int)((int)this.long1), (int)((int)this.long2)), crs, this.currentArrayOffset));
            }
            Types.GEOMETRY_ARRAY.write(this, this.currentArrayOffset++, this.spaceFillingCurve.derivedValueFor(coordinate));
        }
    }

    void writePointDerived(CoordinateReferenceSystem crs, long derivedValue, NativeIndexKey.Inclusion inclusion) {
        if (this.isArray) {
            throw new IllegalStateException("This method is intended to be called when querying, where one or more sub-ranges are derived from a queried range and each sub-range written to separate keys. As such it's unexpected that this key state thinks that it's holds state for an array");
        }
        this.updateCurve(crs.getTable().getTableId(), crs.getCode());
        this.setType(Types.GEOMETRY).write(this, derivedValue);
        this.inclusion = inclusion;
    }

    private void updateCurve(int tableId, int code) {
        if (this.long1 != (long)tableId || this.long2 != (long)code) {
            this.long1 = tableId;
            this.long2 = code;
            this.spaceFillingCurve = this.settings.forCrs(tableId, code, true);
        }
    }

    void writeDurationWithTotalAvgSeconds(long months, long days, long totalAvgSeconds, int nanos) {
        if (!this.isArray) {
            this.setType(Types.DURATION).write(this, months, days, totalAvgSeconds, nanos);
        } else {
            Types.DURATION_ARRAY.write(this, this.currentArrayOffset++, months, days, totalAvgSeconds, nanos);
        }
    }

    public void writeByteArray(byte[] value) {
        PrimitiveArrayWriting.writeTo((ValueWriter)this, (byte[])value);
    }

    public void beginArray(int size, ValueWriter.ArrayType arrayType) {
        AbstractArrayType arrayValueType = Types.BY_ARRAY_TYPE[arrayType.ordinal()];
        this.type = arrayValueType;
        this.initializeArrayMeta(size);
        arrayValueType.initializeArray(this, size, arrayType);
    }

    void initializeArrayMeta(int size) {
        this.isArray = true;
        this.arrayLength = size;
        this.currentArrayOffset = 0;
    }

    public void endArray() {
    }

    public String toString() {
        return this.type.toString(this);
    }

    static void setCursorException(PageCursor cursor, String reason) {
        cursor.setCursorException(String.format("Unable to read generic key slot due to %s", reason));
    }
}

