/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import java.util.StringJoiner;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.GenericKeyState;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettingsCache;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

class CompositeGenericKey
extends NativeIndexKey<CompositeGenericKey> {
    private GenericKeyState[] states;

    CompositeGenericKey(int slots, IndexSpecificSpaceFillingCurveSettingsCache spatialSettings) {
        this.states = new GenericKeyState[slots];
        for (int i = 0; i < this.states.length; ++i) {
            this.states[i] = new GenericKeyState(spatialSettings);
        }
    }

    @Override
    void writeValue(int stateSlot, Value value, NativeIndexKey.Inclusion inclusion) {
        this.states[stateSlot].writeValue(value, inclusion);
    }

    @Override
    void assertValidValue(int stateSlot, Value value) {
        Preconditions.requireBetween((int)stateSlot, (int)0, (int)this.states.length);
    }

    @Override
    void initialize(long entityId) {
        super.initialize(entityId);
        for (GenericKeyState state : this.states) {
            state.clear();
        }
    }

    @Override
    String propertiesAsString() {
        return Arrays.toString(this.asValues());
    }

    @Override
    Value[] asValues() {
        Value[] values = new Value[this.states.length];
        for (int i = 0; i < this.states.length; ++i) {
            values[i] = this.states[i].asValue();
        }
        return values;
    }

    @Override
    void initValueAsLowest(int stateSlot, ValueGroup valueGroup) {
        this.states[stateSlot].initValueAsLowest(valueGroup);
    }

    @Override
    void initValueAsHighest(int stateSlot, ValueGroup valueGroup) {
        this.states[stateSlot].initValueAsHighest(valueGroup);
    }

    void initFromDerivedSpatialValue(int stateSlot, CoordinateReferenceSystem crs, long derivedValue, NativeIndexKey.Inclusion inclusion) {
        this.states[stateSlot].writePointDerived(crs, derivedValue, inclusion);
    }

    void initAsPrefixLow(int stateSlot, String prefix) {
        this.states[stateSlot].initAsPrefixLow(prefix);
    }

    void initAsPrefixHigh(int stateSlot, String prefix) {
        this.states[stateSlot].initAsPrefixHigh(prefix);
    }

    @Override
    int compareValueTo(CompositeGenericKey other) {
        for (int i = 0; i < this.states.length; ++i) {
            int comparison = this.states[i].compareValueTo(other.states[i]);
            if (comparison == 0) continue;
            return comparison;
        }
        return 0;
    }

    void copyValuesFrom(CompositeGenericKey key) {
        if (key.states.length != this.states.length) {
            throw new IllegalArgumentException("Different state lengths " + key.states.length + " vs " + this.states.length);
        }
        for (int i = 0; i < key.states.length; ++i) {
            this.states[i].copyFrom(key.states[i]);
        }
    }

    int size() {
        int size = 8;
        for (GenericKeyState state : this.states) {
            size += state.size();
        }
        return size;
    }

    void write(PageCursor cursor) {
        cursor.putLong(this.getEntityId());
        for (GenericKeyState state : this.states) {
            state.put(cursor);
        }
    }

    void read(PageCursor cursor, int keySize) {
        if (keySize < 8) {
            this.initializeToDummyValue(cursor);
            cursor.setCursorException(String.format("Failed to read CompositeGenericKey due to keySize < ENTITY_ID_SIZE, more precisely %d", keySize));
            return;
        }
        this.initialize(cursor.getLong());
        int offset = cursor.getOffset();
        for (GenericKeyState state : this.states) {
            if (!state.read(cursor, keySize)) {
                this.initializeToDummyValue(cursor);
                return;
            }
            int offsetAfterRead = cursor.getOffset();
            keySize -= offsetAfterRead - offset;
            offset = offsetAfterRead;
        }
    }

    private void initializeToDummyValue(PageCursor cursor) {
        this.setEntityId(Long.MIN_VALUE);
        for (GenericKeyState state : this.states) {
            state.initializeToDummyValue();
        }
    }

    @Override
    int numberOfStateSlots() {
        return this.states.length;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(",", "[", "]");
        for (GenericKeyState state : this.states) {
            joiner.add(state.toString());
        }
        return joiner.toString();
    }

    public static void minimalSplitter(CompositeGenericKey left, CompositeGenericKey right, CompositeGenericKey into) {
        int i;
        int firstStateToDiffer;
        int compare = 0;
        for (firstStateToDiffer = 0; compare == 0 && firstStateToDiffer < right.states.length; ++firstStateToDiffer) {
            GenericKeyState leftState = left.states[firstStateToDiffer];
            GenericKeyState rightState = right.states[firstStateToDiffer];
            compare = leftState.compareValueTo(rightState);
        }
        --firstStateToDiffer;
        for (i = 0; i < firstStateToDiffer; ++i) {
            into.states[i].copyFrom(right.states[i]);
        }
        for (i = firstStateToDiffer; i < into.states.length; ++i) {
            GenericKeyState.minimalSplitter(left.states[i], right.states[i], into.states[i]);
        }
        into.setCompareId(right.getCompareId());
        into.setEntityId(right.getEntityId());
    }
}

