/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.hashing.HashFunction;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;

public class IndexDefinitionImpl
implements IndexDefinition {
    private final InternalSchemaActions actions;
    private final IndexReference indexReference;
    private final Label[] labels;
    private final RelationshipType[] relTypes;
    private final String[] propertyKeys;
    private final boolean constraintIndex;

    public IndexDefinitionImpl(InternalSchemaActions actions, IndexReference ref, Label[] labels, String[] propertyKeys, boolean constraintIndex) {
        this.actions = actions;
        this.indexReference = ref;
        this.labels = labels;
        this.relTypes = null;
        this.propertyKeys = propertyKeys;
        this.constraintIndex = constraintIndex;
        this.assertInUnterminatedTransaction();
    }

    public IndexDefinitionImpl(InternalSchemaActions actions, IndexReference ref, RelationshipType[] relTypes, String[] propertyKeys, boolean constraintIndex) {
        this.actions = actions;
        this.indexReference = ref;
        this.labels = null;
        this.relTypes = relTypes;
        this.propertyKeys = propertyKeys;
        this.constraintIndex = constraintIndex;
        this.assertInUnterminatedTransaction();
    }

    public IndexReference getIndexReference() {
        return this.indexReference;
    }

    public Label getLabel() {
        this.assertInUnterminatedTransaction();
        this.assertIsNodeIndex();
        if (this.labels.length > 1) {
            throw new IllegalStateException("This is a multi-token index, which has more than one label. Call the getLabels() method instead.");
        }
        return this.labels[0];
    }

    public Iterable<Label> getLabels() {
        this.assertInUnterminatedTransaction();
        this.assertIsNodeIndex();
        return Arrays.asList(this.labels);
    }

    public RelationshipType getRelationshipType() {
        this.assertInUnterminatedTransaction();
        this.assertIsRelationshipIndex();
        if (this.relTypes.length > 1) {
            throw new IllegalStateException("This is a multi-token index, which has more than one relationship type. Call the getRelationshipTypes() method instead.");
        }
        return this.relTypes[0];
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        this.assertInUnterminatedTransaction();
        this.assertIsRelationshipIndex();
        return Arrays.asList(this.relTypes);
    }

    public Iterable<String> getPropertyKeys() {
        this.assertInUnterminatedTransaction();
        return Arrays.asList(this.propertyKeys);
    }

    String[] getPropertyKeysArrayShared() {
        this.assertInUnterminatedTransaction();
        return this.propertyKeys;
    }

    Label[] getLabelArrayShared() {
        return this.labels;
    }

    RelationshipType[] getRelationshipTypesArrayShared() {
        return this.relTypes;
    }

    public void drop() {
        try {
            this.actions.dropIndexDefinitions(this);
        }
        catch (ConstraintViolationException e) {
            if (this.isConstraintIndex()) {
                throw new IllegalStateException("Constraint indexes cannot be dropped directly, instead drop the owning uniqueness constraint.", e);
            }
            throw e;
        }
    }

    public boolean isConstraintIndex() {
        this.assertInUnterminatedTransaction();
        return this.constraintIndex;
    }

    public boolean isNodeIndex() {
        this.assertInUnterminatedTransaction();
        return this.internalIsNodeIndex();
    }

    private boolean internalIsNodeIndex() {
        return this.labels != null;
    }

    public boolean isRelationshipIndex() {
        this.assertInUnterminatedTransaction();
        return this.relTypes != null;
    }

    public boolean isMultiTokenIndex() {
        this.assertInUnterminatedTransaction();
        return this.internalIsNodeIndex() ? this.labels.length > 1 : this.relTypes.length > 1;
    }

    public boolean isCompositeIndex() {
        this.assertInUnterminatedTransaction();
        return this.propertyKeys.length > 1;
    }

    public int hashCode() {
        HashFunction hf = HashFunction.incrementalXXH64();
        long hash = hf.initialise(31L);
        hash = hf.updateWithArray(hash, (Object[])this.labels, label -> label.name().hashCode());
        hash = hf.updateWithArray(hash, (Object[])this.relTypes, relType -> relType.name().hashCode());
        hash = hf.updateWithArray(hash, (Object[])this.propertyKeys, String::hashCode);
        return hf.toInt(hash);
    }

    public boolean equals(Object obj) {
        int i;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexDefinitionImpl other = (IndexDefinitionImpl)obj;
        if (this.internalIsNodeIndex()) {
            if (other.labels == null) {
                return false;
            }
            if (this.labels.length != other.labels.length) {
                return false;
            }
            for (i = 0; i < this.labels.length; ++i) {
                if (this.labels[i].name().equals(other.labels[i].name())) continue;
                return false;
            }
        }
        if (this.relTypes != null) {
            if (other.relTypes == null) {
                return false;
            }
            if (this.relTypes.length != other.relTypes.length) {
                return false;
            }
            for (i = 0; i < this.relTypes.length; ++i) {
                if (this.relTypes[i].name().equals(other.relTypes[i].name())) continue;
                return false;
            }
        }
        return Arrays.equals(this.propertyKeys, other.propertyKeys);
    }

    public String toString() {
        String entityTokens;
        String entityTokenType;
        if (this.internalIsNodeIndex()) {
            entityTokenType = this.labels.length > 1 ? "labels" : "label";
            entityTokens = Arrays.stream(this.labels).map(Label::name).collect(Collectors.joining(","));
        } else {
            entityTokenType = this.relTypes.length > 1 ? "relationship types" : "relationship type";
            entityTokens = Arrays.stream(this.relTypes).map(RelationshipType::name).collect(Collectors.joining(","));
        }
        return "IndexDefinition[" + entityTokenType + ":" + entityTokens + " on:" + String.join((CharSequence)",", this.propertyKeys) + "]" + (this.indexReference == null ? "" : " (" + this.indexReference + ")");
    }

    private void assertInUnterminatedTransaction() {
        this.actions.assertInOpenTransaction();
    }

    private void assertIsNodeIndex() {
        if (!this.isNodeIndex()) {
            throw new IllegalStateException("This is not a node index.");
        }
    }

    private void assertIsRelationshipIndex() {
        if (!this.isRelationshipIndex()) {
            throw new IllegalStateException("This is not a relationship index.");
        }
    }
}

