/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.impl.UnmodifiableMap;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.impl.newapi.NodeWithPropertyValues;
import org.neo4j.kernel.impl.util.diffsets.MutableDiffSetsImpl;
import org.neo4j.kernel.impl.util.diffsets.MutableLongDiffSetsImpl;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.txstate.DiffSets;
import org.neo4j.storageengine.api.txstate.LongDiffSets;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

class TxStateIndexChanges {
    private static final ValueTuple MAX_STRING_TUPLE = ValueTuple.of((Value[])new Value[]{Values.MAX_STRING});

    TxStateIndexChanges() {
    }

    static LongDiffSets indexUpdatesForScan(ReadableTransactionState txState, IndexDescriptor descriptor) {
        UnmodifiableMap updates = txState.getIndexUpdates(descriptor.schema());
        if (updates == null) {
            return LongDiffSets.EMPTY;
        }
        MutableLongDiffSetsImpl diffs = new MutableLongDiffSetsImpl();
        for (LongDiffSets diffSet : updates.values()) {
            diffs.addAll((LongIterable)diffSet.getAdded());
            diffs.removeAll((LongIterable)diffSet.getRemoved());
        }
        return diffs;
    }

    static DiffSets<NodeWithPropertyValues> indexUpdatesWithValuesForScan(ReadableTransactionState txState, IndexDescriptor descriptor) {
        UnmodifiableMap updates = txState.getIndexUpdates(descriptor.schema());
        if (updates == null) {
            return DiffSets.Empty.instance();
        }
        MutableDiffSetsImpl<NodeWithPropertyValues> diffs = new MutableDiffSetsImpl<NodeWithPropertyValues>();
        for (Map.Entry entry : updates.entrySet()) {
            Value[] values = ((ValueTuple)entry.getKey()).getValues();
            LongDiffSets diffSets = (LongDiffSets)entry.getValue();
            diffSets.getAdded().each((LongProcedure & Serializable)nodeId -> diffs.add(new NodeWithPropertyValues(nodeId, values)));
            diffSets.getRemoved().each((LongProcedure & Serializable)nodeId -> diffs.remove(new NodeWithPropertyValues(nodeId, values)));
        }
        return diffs;
    }

    static LongDiffSets indexUpdatesForSuffixOrContains(ReadableTransactionState txState, IndexDescriptor descriptor, IndexQuery query) {
        if (descriptor.schema().getPropertyIds().length != 1) {
            throw new IllegalStateException("Suffix and contains queries are only supported for single property queries");
        }
        UnmodifiableMap updates = txState.getIndexUpdates(descriptor.schema());
        if (updates == null) {
            return LongDiffSets.EMPTY;
        }
        MutableLongDiffSetsImpl diffs = new MutableLongDiffSetsImpl();
        for (Map.Entry entry : updates.entrySet()) {
            if (!query.acceptsValue(((ValueTuple)entry.getKey()).getOnlyValue())) continue;
            LongDiffSets diffsets = (LongDiffSets)entry.getValue();
            diffs.addAll((LongIterable)diffsets.getAdded());
            diffs.removeAll((LongIterable)diffsets.getRemoved());
        }
        return diffs;
    }

    static DiffSets<NodeWithPropertyValues> indexUpdatesWithValuesForSuffixOrContains(ReadableTransactionState txState, IndexDescriptor descriptor, IndexQuery query) {
        if (descriptor.schema().getPropertyIds().length != 1) {
            throw new IllegalStateException("Suffix and contains queries are only supported for single property queries");
        }
        UnmodifiableMap updates = txState.getIndexUpdates(descriptor.schema());
        if (updates == null) {
            return DiffSets.Empty.instance();
        }
        MutableDiffSetsImpl<NodeWithPropertyValues> diffs = new MutableDiffSetsImpl<NodeWithPropertyValues>();
        for (Map.Entry entry : updates.entrySet()) {
            ValueTuple key = (ValueTuple)entry.getKey();
            if (!query.acceptsValue(key.getOnlyValue())) continue;
            Value[] values = key.getValues();
            LongDiffSets diffSets = (LongDiffSets)entry.getValue();
            diffSets.getAdded().each((LongProcedure & Serializable)nodeId -> diffs.add(new NodeWithPropertyValues(nodeId, values)));
            diffSets.getRemoved().each((LongProcedure & Serializable)nodeId -> diffs.remove(new NodeWithPropertyValues(nodeId, values)));
        }
        return diffs;
    }

    static LongDiffSets indexUpdatesForSeek(ReadableTransactionState txState, IndexDescriptor descriptor, ValueTuple values) {
        UnmodifiableMap updates = txState.getIndexUpdates(descriptor.schema());
        if (updates != null) {
            LongDiffSets indexUpdatesForSeek = (LongDiffSets)updates.get((Object)values);
            return indexUpdatesForSeek == null ? LongDiffSets.EMPTY : indexUpdatesForSeek;
        }
        return LongDiffSets.EMPTY;
    }

    static LongDiffSets indexUpdatesForRangeSeek(ReadableTransactionState txState, IndexDescriptor descriptor, IndexQuery.RangePredicate<?> predicate) {
        boolean selectedIncludeUpper;
        ValueTuple selectedUpper;
        boolean selectedIncludeLower;
        ValueTuple selectedLower;
        Value lower = predicate.fromValue();
        Value upper = predicate.toValue();
        if (lower == null || upper == null) {
            throw new IllegalStateException("Use Values.NO_VALUE to encode the lack of a bound");
        }
        NavigableMap sortedUpdates = txState.getSortedIndexUpdates(descriptor.schema());
        if (sortedUpdates == null) {
            return LongDiffSets.EMPTY;
        }
        if (lower == Values.NO_VALUE) {
            selectedLower = ValueTuple.of((Value[])new Value[]{Values.minValue((ValueGroup)predicate.valueGroup(), (Value)upper)});
            selectedIncludeLower = true;
        } else {
            selectedLower = ValueTuple.of((Value[])new Value[]{lower});
            selectedIncludeLower = predicate.fromInclusive();
        }
        if (upper == Values.NO_VALUE) {
            selectedUpper = ValueTuple.of((Value[])new Value[]{Values.maxValue((ValueGroup)predicate.valueGroup(), (Value)lower)});
            selectedIncludeUpper = false;
        } else {
            selectedUpper = ValueTuple.of((Value[])new Value[]{upper});
            selectedIncludeUpper = predicate.toInclusive();
        }
        MutableLongDiffSetsImpl diffs = new MutableLongDiffSetsImpl();
        NavigableMap inRange = sortedUpdates.subMap(selectedLower, selectedIncludeLower, selectedUpper, selectedIncludeUpper);
        for (Map.Entry entry : inRange.entrySet()) {
            ValueTuple values = (ValueTuple)entry.getKey();
            LongDiffSets diffForSpecificValue = (LongDiffSets)entry.getValue();
            if (!predicate.isRegularOrder() && !predicate.acceptsValue(values.getOnlyValue())) continue;
            diffs.addAll((LongIterable)diffForSpecificValue.getAdded());
            diffs.removeAll((LongIterable)diffForSpecificValue.getRemoved());
        }
        return diffs;
    }

    static DiffSets<NodeWithPropertyValues> indexUpdatesWithValuesForRangeSeek(ReadableTransactionState txState, IndexDescriptor descriptor, IndexQuery.RangePredicate<?> predicate) {
        boolean selectedIncludeUpper;
        ValueTuple selectedUpper;
        boolean selectedIncludeLower;
        ValueTuple selectedLower;
        Value lower = predicate.fromValue();
        Value upper = predicate.toValue();
        if (lower == null || upper == null) {
            throw new IllegalStateException("Use Values.NO_VALUE to encode the lack of a bound");
        }
        NavigableMap sortedUpdates = txState.getSortedIndexUpdates(descriptor.schema());
        if (sortedUpdates == null) {
            return DiffSets.Empty.instance();
        }
        if (lower == Values.NO_VALUE) {
            selectedLower = ValueTuple.of((Value[])new Value[]{Values.minValue((ValueGroup)predicate.valueGroup(), (Value)upper)});
            selectedIncludeLower = true;
        } else {
            selectedLower = ValueTuple.of((Value[])new Value[]{lower});
            selectedIncludeLower = predicate.fromInclusive();
        }
        if (upper == Values.NO_VALUE) {
            selectedUpper = ValueTuple.of((Value[])new Value[]{Values.maxValue((ValueGroup)predicate.valueGroup(), (Value)lower)});
            selectedIncludeUpper = false;
        } else {
            selectedUpper = ValueTuple.of((Value[])new Value[]{upper});
            selectedIncludeUpper = predicate.toInclusive();
        }
        MutableDiffSetsImpl<NodeWithPropertyValues> diffs = new MutableDiffSetsImpl<NodeWithPropertyValues>();
        NavigableMap inRange = sortedUpdates.subMap(selectedLower, selectedIncludeLower, selectedUpper, selectedIncludeUpper);
        for (Map.Entry entry : inRange.entrySet()) {
            ValueTuple values = (ValueTuple)entry.getKey();
            Value[] valuesArray = values.getValues();
            LongDiffSets diffForSpecificValue = (LongDiffSets)entry.getValue();
            if (!predicate.isRegularOrder() && !predicate.acceptsValue(values.getOnlyValue())) continue;
            diffForSpecificValue.getAdded().each((LongProcedure & Serializable)nodeId -> diffs.add(new NodeWithPropertyValues(nodeId, valuesArray)));
            diffForSpecificValue.getRemoved().each((LongProcedure & Serializable)nodeId -> diffs.remove(new NodeWithPropertyValues(nodeId, valuesArray)));
        }
        return diffs;
    }

    static LongDiffSets indexUpdatesForRangeSeekByPrefix(ReadableTransactionState txState, IndexDescriptor descriptor, String prefix) {
        Map.Entry entry;
        ValueTuple key;
        NavigableMap sortedUpdates = txState.getSortedIndexUpdates(descriptor.schema());
        if (sortedUpdates == null) {
            return LongDiffSets.EMPTY;
        }
        ValueTuple floor = ValueTuple.of((Value[])new Value[]{Values.stringValue((String)prefix)});
        MutableLongDiffSetsImpl diffs = new MutableLongDiffSetsImpl();
        Iterator iterator = sortedUpdates.subMap(floor, MAX_STRING_TUPLE).entrySet().iterator();
        while (iterator.hasNext() && ((TextValue)(key = (entry = iterator.next()).getKey()).getOnlyValue()).stringValue().startsWith(prefix)) {
            LongDiffSets diffSets = (LongDiffSets)entry.getValue();
            diffs.addAll((LongIterable)diffSets.getAdded());
            diffs.removeAll((LongIterable)diffSets.getRemoved());
        }
        return diffs;
    }

    static DiffSets<NodeWithPropertyValues> indexUpdatesWithValuesForRangeSeekByPrefix(ReadableTransactionState txState, IndexDescriptor descriptor, String prefix) {
        Map.Entry entry;
        ValueTuple key;
        NavigableMap sortedUpdates = txState.getSortedIndexUpdates(descriptor.schema());
        if (sortedUpdates == null) {
            return DiffSets.Empty.instance();
        }
        ValueTuple floor = ValueTuple.of((Value[])new Value[]{Values.stringValue((String)prefix)});
        MutableDiffSetsImpl<NodeWithPropertyValues> diffs = new MutableDiffSetsImpl<NodeWithPropertyValues>();
        Iterator iterator = sortedUpdates.tailMap(floor).entrySet().iterator();
        while (iterator.hasNext() && ((TextValue)(key = (entry = iterator.next()).getKey()).getOnlyValue()).stringValue().startsWith(prefix)) {
            LongDiffSets diffSets = (LongDiffSets)entry.getValue();
            Value[] values = key.getValues();
            diffSets.getAdded().each((LongProcedure & Serializable)nodeId -> diffs.add(new NodeWithPropertyValues(nodeId, values)));
            diffSets.getRemoved().each((LongProcedure & Serializable)nodeId -> diffs.remove(new NodeWithPropertyValues(nodeId, values)));
        }
        return diffs;
    }
}

