/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.index.IndexMapReference;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexProxyCreator;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.MultiPopulatorFactory;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingController;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingControllerFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;

public class IndexingServiceFactory {
    private IndexingServiceFactory() {
    }

    public static IndexingService createIndexingService(Config config, JobScheduler scheduler, IndexProviderMap providerMap, IndexStoreView storeView, TokenNameLookup tokenNameLookup, Iterable<StoreIndexDescriptor> indexRules, LogProvider logProvider, IndexingService.Monitor monitor, SchemaState schemaState) {
        IndexSamplingConfig samplingConfig = new IndexSamplingConfig(config);
        MultiPopulatorFactory multiPopulatorFactory = MultiPopulatorFactory.forConfig(config);
        IndexMapReference indexMapRef = new IndexMapReference();
        IndexSamplingControllerFactory factory = new IndexSamplingControllerFactory(samplingConfig, storeView, scheduler, tokenNameLookup, logProvider);
        IndexSamplingController indexSamplingController = factory.create(indexMapRef);
        IndexProxyCreator proxySetup = new IndexProxyCreator(samplingConfig, storeView, providerMap, tokenNameLookup, logProvider);
        return new IndexingService(proxySetup, providerMap, indexMapRef, storeView, indexRules, indexSamplingController, tokenNameLookup, scheduler, schemaState, multiPopulatorFactory, logProvider, monitor);
    }
}

