/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.input.CachingInputIterator;
import org.neo4j.unsafe.impl.batchimport.input.InputCache;
import org.neo4j.unsafe.impl.batchimport.input.InputCacher;

class CachingInputIterable
implements InputIterable {
    private final InputIterable actual;
    private final InputCache cache;
    private boolean firstTime = true;

    CachingInputIterable(InputIterable actual, InputCache cache) {
        this.cache = cache;
        this.actual = actual;
    }

    @Override
    public boolean supportsMultiplePasses() {
        return true;
    }

    @Override
    public InputIterator iterator() {
        if (this.actual.supportsMultiplePasses()) {
            return this.actual.iterator();
        }
        try {
            if (this.firstTime) {
                this.firstTime = false;
                InputCacher cacher = this.cache.cacheNodes();
                return new CachingInputIterator(this.actual.iterator(), cacher);
            }
            return this.cache.nodes().iterator();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

