/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.function.IntPredicate;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.api.index.EntityUpdates;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.PropertyLoader;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.transaction.state.storeview.RelationshipStoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.StoreViewNodeStoreScan;
import org.neo4j.register.Register;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class NeoStoreIndexStoreView
implements IndexStoreView {
    protected final PropertyStore propertyStore;
    protected final NodeStore nodeStore;
    protected final RelationshipStore relationshipStore;
    protected final LockService locks;
    private final CountsTracker counts;

    public NeoStoreIndexStoreView(LockService locks, NeoStores neoStores) {
        this.locks = locks;
        this.propertyStore = neoStores.getPropertyStore();
        this.nodeStore = neoStores.getNodeStore();
        this.relationshipStore = neoStores.getRelationshipStore();
        this.counts = neoStores.getCounts();
    }

    @Override
    public Register.DoubleLongRegister indexUpdatesAndSize(long indexId, Register.DoubleLongRegister output) {
        return this.counts.indexUpdatesAndSize(indexId, output);
    }

    @Override
    public void replaceIndexCounts(long indexId, long uniqueElements, long maxUniqueElements, long indexSize) {
        try (CountsAccessor.IndexStatsUpdater updater = this.counts.updateIndexCounts();){
            updater.replaceIndexSample(indexId, uniqueElements, maxUniqueElements);
            updater.replaceIndexUpdateAndSize(indexId, 0L, indexSize);
        }
    }

    @Override
    public void incrementIndexUpdates(long indexId, long updatesDelta) {
        try (CountsAccessor.IndexStatsUpdater updater = this.counts.updateIndexCounts();){
            updater.incrementIndexUpdates(indexId, updatesDelta);
        }
    }

    @Override
    public Register.DoubleLongRegister indexSample(long indexId, Register.DoubleLongRegister output) {
        return this.counts.indexSample(indexId, output);
    }

    @Override
    public <FAILURE extends Exception> StoreScan<FAILURE> visitNodes(int[] labelIds, IntPredicate propertyKeyIdFilter, Visitor<EntityUpdates, FAILURE> propertyUpdatesVisitor, Visitor<NodeLabelUpdate, FAILURE> labelUpdateVisitor, boolean forceStoreScan) {
        return new StoreViewNodeStoreScan<FAILURE>(this.nodeStore, this.locks, this.propertyStore, labelUpdateVisitor, propertyUpdatesVisitor, labelIds, propertyKeyIdFilter);
    }

    @Override
    public <FAILURE extends Exception> StoreScan<FAILURE> visitRelationships(int[] relationshipTypeIds, IntPredicate propertyKeyIdFilter, Visitor<EntityUpdates, FAILURE> propertyUpdatesVisitor) {
        return new RelationshipStoreScan<FAILURE>(this.relationshipStore, this.locks, this.propertyStore, propertyUpdatesVisitor, relationshipTypeIds, propertyKeyIdFilter);
    }

    @Override
    public EntityUpdates nodeAsUpdates(long nodeId) {
        NodeRecord node = (NodeRecord)this.nodeStore.getRecord(nodeId, this.nodeStore.newRecord(), RecordLoad.FORCE);
        if (!node.inUse()) {
            return null;
        }
        long firstPropertyId = node.getNextProp();
        if (firstPropertyId == (long)Record.NO_NEXT_PROPERTY.intValue()) {
            return null;
        }
        long[] labels = NodeLabelsField.parseLabelsField(node).get(this.nodeStore);
        if (labels.length == 0) {
            return null;
        }
        EntityUpdates.Builder update = EntityUpdates.forEntity(nodeId).withTokens(labels);
        for (PropertyRecord propertyRecord : this.propertyStore.getPropertyRecordChain(firstPropertyId)) {
            for (PropertyBlock property : propertyRecord) {
                Value value = property.getType().value(property, this.propertyStore);
                update.added(property.getKeyIndexId(), value);
            }
        }
        return update.build();
    }

    @Override
    public Value getNodePropertyValue(long nodeId, int propertyKeyId) throws EntityNotFoundException {
        NodeRecord node = (NodeRecord)this.nodeStore.getRecord(nodeId, this.nodeStore.newRecord(), RecordLoad.FORCE);
        if (!node.inUse()) {
            throw new EntityNotFoundException(EntityType.NODE, nodeId);
        }
        long firstPropertyId = node.getNextProp();
        if (firstPropertyId == (long)Record.NO_NEXT_PROPERTY.intValue()) {
            return Values.NO_VALUE;
        }
        for (PropertyRecord propertyRecord : this.propertyStore.getPropertyRecordChain(firstPropertyId)) {
            PropertyBlock propertyBlock = propertyRecord.getPropertyBlock(propertyKeyId);
            if (propertyBlock == null) continue;
            return propertyBlock.newPropertyValue(this.propertyStore);
        }
        return Values.NO_VALUE;
    }

    @Override
    public void loadProperties(long entityId, EntityType type, MutableIntSet propertyIds, PropertyLoader.PropertyLoadSink sink) {
        PrimitiveRecord entity = type == EntityType.NODE ? (PrimitiveRecord)this.nodeStore.getRecord(entityId, this.nodeStore.newRecord(), RecordLoad.FORCE) : (PrimitiveRecord)this.relationshipStore.getRecord(entityId, this.relationshipStore.newRecord(), RecordLoad.FORCE);
        if (!entity.inUse()) {
            return;
        }
        long firstPropertyId = entity.getNextProp();
        if (firstPropertyId == (long)Record.NO_NEXT_PROPERTY.intValue()) {
            return;
        }
        for (PropertyRecord propertyRecord : this.propertyStore.getPropertyRecordChain(firstPropertyId)) {
            for (PropertyBlock block : propertyRecord) {
                int currentPropertyId = block.getKeyIndexId();
                if (!propertyIds.remove(currentPropertyId)) continue;
                Value currentValue = block.getType().value(block, this.propertyStore);
                sink.onProperty(currentPropertyId, currentValue);
            }
        }
    }
}

