/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.map.primitive.LongObjectMap;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.impl.api.index.EntityUpdates;
import org.neo4j.kernel.impl.api.index.IndexingUpdateService;
import org.neo4j.kernel.impl.api.index.PropertyPhysicalToLogicalConverter;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.state.IndexUpdates;
import org.neo4j.storageengine.api.EntityType;

public class OnlineIndexUpdates
implements IndexUpdates {
    private final NodeStore nodeStore;
    private final RelationshipStore relationshipStore;
    private final IndexingUpdateService updateService;
    private final PropertyPhysicalToLogicalConverter converter;
    private final Collection<IndexEntryUpdate<SchemaDescriptor>> updates = new ArrayList<IndexEntryUpdate<SchemaDescriptor>>();
    private NodeRecord nodeRecord;
    private RelationshipRecord relationshipRecord;

    public OnlineIndexUpdates(NodeStore nodeStore, RelationshipStore relationshipStore, IndexingUpdateService updateService, PropertyPhysicalToLogicalConverter converter) {
        this.nodeStore = nodeStore;
        this.relationshipStore = relationshipStore;
        this.updateService = updateService;
        this.converter = converter;
    }

    @Override
    public Iterator<IndexEntryUpdate<SchemaDescriptor>> iterator() {
        return this.updates.iterator();
    }

    @Override
    public void feed(LongObjectMap<List<Command.PropertyCommand>> propCommandsByNodeId, LongObjectMap<List<Command.PropertyCommand>> propertyCommandsByRelationshipId, LongObjectMap<Command.NodeCommand> nodeCommands, LongObjectMap<Command.RelationshipCommand> relationshipCommands) {
        LongIterator nodeIds = this.allKeys(nodeCommands, propCommandsByNodeId).longIterator();
        while (nodeIds.hasNext()) {
            long nodeId = nodeIds.next();
            this.gatherUpdatesFor(nodeId, (Command.NodeCommand)nodeCommands.get(nodeId), (List<Command.PropertyCommand>)((List)propCommandsByNodeId.get(nodeId)));
        }
        LongIterator relationshipIds = this.allKeys(relationshipCommands, propertyCommandsByRelationshipId).longIterator();
        while (relationshipIds.hasNext()) {
            long relationshipId = relationshipIds.next();
            this.gatherUpdatesFor(relationshipId, (Command.RelationshipCommand)relationshipCommands.get(relationshipId), (List<Command.PropertyCommand>)((List)propertyCommandsByRelationshipId.get(relationshipId)));
        }
    }

    private LongSet allKeys(LongObjectMap ... maps) {
        LongHashSet keys = new LongHashSet();
        for (LongObjectMap map : maps) {
            keys.addAll((LongIterable)map.keySet());
        }
        return keys;
    }

    @Override
    public boolean hasUpdates() {
        return !this.updates.isEmpty();
    }

    private void gatherUpdatesFor(long nodeId, Command.NodeCommand nodeCommand, List<Command.PropertyCommand> propertyCommands) {
        EntityUpdates.Builder nodePropertyUpdate = this.gatherUpdatesFromCommandsForNode(nodeId, nodeCommand, propertyCommands);
        EntityUpdates entityUpdates = nodePropertyUpdate.build();
        for (IndexEntryUpdate<SchemaDescriptor> update : this.updateService.convertToIndexUpdates(entityUpdates, EntityType.NODE)) {
            this.updates.add(update);
        }
    }

    private void gatherUpdatesFor(long reltionshipId, Command.RelationshipCommand relationshipCommand, List<Command.PropertyCommand> propertyCommands) {
        EntityUpdates.Builder relationshipPropertyUpdate = this.gatherUpdatesFromCommandsForRelationship(reltionshipId, relationshipCommand, propertyCommands);
        EntityUpdates entityUpdates = relationshipPropertyUpdate.build();
        for (IndexEntryUpdate<SchemaDescriptor> update : this.updateService.convertToIndexUpdates(entityUpdates, EntityType.RELATIONSHIP)) {
            this.updates.add(update);
        }
    }

    private EntityUpdates.Builder gatherUpdatesFromCommandsForNode(long nodeId, Command.NodeCommand nodeChanges, List<Command.PropertyCommand> propertyCommandsForNode) {
        long[] nodeLabelsAfter;
        long[] nodeLabelsBefore;
        if (nodeChanges != null) {
            nodeLabelsBefore = NodeLabelsField.parseLabelsField((NodeRecord)nodeChanges.getBefore()).get(this.nodeStore);
            nodeLabelsAfter = NodeLabelsField.parseLabelsField((NodeRecord)nodeChanges.getAfter()).get(this.nodeStore);
        } else {
            NodeRecord nodeRecord = this.loadNode(nodeId);
            nodeLabelsBefore = nodeLabelsAfter = NodeLabelsField.parseLabelsField(nodeRecord).get(this.nodeStore);
        }
        EntityUpdates.Builder nodePropertyUpdates = EntityUpdates.forEntity(nodeId).withTokens(nodeLabelsBefore).withTokensAfter(nodeLabelsAfter);
        if (propertyCommandsForNode != null) {
            this.converter.convertPropertyRecord(nodeId, Iterables.cast(propertyCommandsForNode), nodePropertyUpdates);
        }
        return nodePropertyUpdates;
    }

    private EntityUpdates.Builder gatherUpdatesFromCommandsForRelationship(long relationshipId, Command.RelationshipCommand relationshipCommand, List<Command.PropertyCommand> propertyCommands) {
        long reltypeAfter;
        long reltypeBefore;
        if (relationshipCommand != null) {
            reltypeBefore = ((RelationshipRecord)relationshipCommand.getBefore()).getType();
            reltypeAfter = ((RelationshipRecord)relationshipCommand.getAfter()).getType();
        } else {
            RelationshipRecord relationshipRecord = this.loadRelationship(relationshipId);
            reltypeBefore = reltypeAfter = (long)relationshipRecord.getType();
        }
        EntityUpdates.Builder relationshipPropertyUpdates = EntityUpdates.forEntity(relationshipId).withTokens(reltypeBefore).withTokensAfter(reltypeAfter);
        if (propertyCommands != null) {
            this.converter.convertPropertyRecord(relationshipId, Iterables.cast(propertyCommands), relationshipPropertyUpdates);
        }
        return relationshipPropertyUpdates;
    }

    private NodeRecord loadNode(long nodeId) {
        if (this.nodeRecord == null) {
            this.nodeRecord = (NodeRecord)this.nodeStore.newRecord();
        }
        this.nodeStore.getRecord(nodeId, this.nodeRecord, RecordLoad.NORMAL);
        return this.nodeRecord;
    }

    private RelationshipRecord loadRelationship(long relationshipId) {
        if (this.relationshipRecord == null) {
            this.relationshipRecord = (RelationshipRecord)this.relationshipStore.newRecord();
        }
        this.relationshipStore.getRecord(relationshipId, this.relationshipRecord, RecordLoad.NORMAL);
        return this.relationshipRecord;
    }
}

