/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.File;
import java.io.IOException;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.pruning.Threshold;

public final class EntryCountThreshold
implements Threshold {
    private final long maxTransactionCount;

    EntryCountThreshold(long maxTransactionCount) {
        this.maxTransactionCount = maxTransactionCount;
    }

    @Override
    public void init() {
    }

    @Override
    public boolean reached(File ignored, long version, LogFileInformation source) {
        try {
            long lastTx = source.getFirstEntryId(version + 1L);
            if (lastTx == -1L) {
                throw new IllegalStateException("The next version should always exist, since this is called after rotation and the PruneStrategy never checks the current active log file");
            }
            long highest = source.getLastEntryId();
            return highest - lastTx >= this.maxTransactionCount;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

