/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.allocator.ReusableRecordsCompositeAllocator;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.SchemaRuleSerialization;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class SchemaStore
extends AbstractDynamicStore
implements Iterable<SchemaRule> {
    public static final String TYPE_DESCRIPTOR = "SchemaStore";
    public static final int BLOCK_SIZE = 56;

    public SchemaStore(File fileName, Config conf, IdType idType, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, RecordFormats recordFormats, OpenOption ... openOptions) {
        super(fileName, conf, idType, idGeneratorFactory, pageCache, logProvider, TYPE_DESCRIPTOR, 56, recordFormats.dynamic(), recordFormats.storeVersion(), openOptions);
    }

    @Override
    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, DynamicRecord record) throws FAILURE {
        processor.processSchema(this, record);
    }

    public List<DynamicRecord> allocateFrom(SchemaRule rule) {
        ArrayList<DynamicRecord> records = new ArrayList<DynamicRecord>();
        DynamicRecord record = this.getRecord(rule.getId(), this.nextRecord(), RecordLoad.CHECK);
        ReusableRecordsCompositeAllocator recordAllocator = new ReusableRecordsCompositeAllocator(Collections.singleton(record), (DynamicRecordAllocator)this);
        SchemaStore.allocateRecordsFromBytes(records, SchemaRuleSerialization.serialize(rule), recordAllocator);
        return records;
    }

    public Iterator<SchemaRule> loadAllSchemaRules() {
        return new SchemaStorage(this).loadAllSchemaRules();
    }

    @Override
    public Iterator<SchemaRule> iterator() {
        return this.loadAllSchemaRules();
    }

    static SchemaRule readSchemaRule(long id, Collection<DynamicRecord> records, byte[] buffer) throws MalformedSchemaRuleException {
        ByteBuffer scratchBuffer = SchemaStore.concatData(records, buffer);
        return SchemaRuleSerialization.deserialize(id, scratchBuffer);
    }
}

