/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.community;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.stream.Stream;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.IntObjectProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongObjectProcedure;
import org.eclipse.collections.api.map.primitive.LongObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.locking.ActiveLock;
import org.neo4j.kernel.impl.locking.LockClientStateHolder;
import org.neo4j.kernel.impl.locking.LockClientStoppedException;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.locking.community.LockManagerImpl;
import org.neo4j.kernel.impl.locking.community.LockResource;
import org.neo4j.kernel.impl.locking.community.LockTransaction;
import org.neo4j.kernel.impl.locking.community.RWLock;
import org.neo4j.storageengine.api.lock.ResourceType;

public class CommunityLockClient
implements Locks.Client {
    private final LockManagerImpl manager;
    private final LockTransaction lockTransaction = new LockTransaction();
    private final MutableIntObjectMap<MutableLongObjectMap<LockResource>> sharedLocks = new IntObjectHashMap();
    private final MutableIntObjectMap<MutableLongObjectMap<LockResource>> exclusiveLocks = new IntObjectHashMap();
    private final LongObjectProcedure<LockResource> readReleaser;
    private final LongObjectProcedure<LockResource> writeReleaser;
    private final Procedure<LongObjectMap<LockResource>> typeReadReleaser;
    private final Procedure<LongObjectMap<LockResource>> typeWriteReleaser;
    private final LockClientStateHolder stateHolder = new LockClientStateHolder();

    public CommunityLockClient(LockManagerImpl manager) {
        this.manager = manager;
        this.readReleaser = (LongObjectProcedure & Serializable)(key, lockResource) -> manager.releaseReadLock(lockResource, this.lockTransaction);
        this.writeReleaser = (LongObjectProcedure & Serializable)(key, lockResource) -> manager.releaseWriteLock(lockResource, this.lockTransaction);
        this.typeReadReleaser = (Procedure & Serializable)value -> value.forEachKeyValue(this.readReleaser);
        this.typeWriteReleaser = (Procedure & Serializable)value -> value.forEachKeyValue(this.writeReleaser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquireShared(LockTracer tracer, ResourceType resourceType, long ... resourceIds) {
        this.stateHolder.incrementActiveClients(this);
        try {
            MutableLongObjectMap<LockResource> localLocks = this.localShared(resourceType);
            for (long resourceId : resourceIds) {
                LockResource resource = (LockResource)localLocks.get(resourceId);
                if (resource != null) {
                    resource.acquireReference();
                    continue;
                }
                resource = new LockResource(resourceType, resourceId);
                if (this.manager.getReadLock(tracer, resource, this.lockTransaction)) {
                    localLocks.put(resourceId, (Object)resource);
                    continue;
                }
                throw new LockClientStoppedException(this);
            }
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquireExclusive(LockTracer tracer, ResourceType resourceType, long ... resourceIds) {
        this.stateHolder.incrementActiveClients(this);
        try {
            MutableLongObjectMap<LockResource> localLocks = this.localExclusive(resourceType);
            for (long resourceId : resourceIds) {
                LockResource resource = (LockResource)localLocks.get(resourceId);
                if (resource != null) {
                    resource.acquireReference();
                    continue;
                }
                resource = new LockResource(resourceType, resourceId);
                if (this.manager.getWriteLock(tracer, resource, this.lockTransaction)) {
                    localLocks.put(resourceId, (Object)resource);
                    continue;
                }
                throw new LockClientStoppedException(this);
            }
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryExclusiveLock(ResourceType resourceType, long resourceId) {
        this.stateHolder.incrementActiveClients(this);
        try {
            MutableLongObjectMap<LockResource> localLocks = this.localExclusive(resourceType);
            LockResource resource = (LockResource)localLocks.get(resourceId);
            if (resource != null) {
                resource.acquireReference();
                boolean bl = true;
                return bl;
            }
            resource = new LockResource(resourceType, resourceId);
            if (this.manager.tryWriteLock(resource, this.lockTransaction)) {
                localLocks.put(resourceId, (Object)resource);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean trySharedLock(ResourceType resourceType, long resourceId) {
        this.stateHolder.incrementActiveClients(this);
        try {
            MutableLongObjectMap<LockResource> localLocks = this.localShared(resourceType);
            LockResource resource = (LockResource)localLocks.get(resourceId);
            if (resource != null) {
                resource.acquireReference();
                boolean bl = true;
                return bl;
            }
            resource = new LockResource(resourceType, resourceId);
            if (this.manager.tryReadLock(resource, this.lockTransaction)) {
                localLocks.put(resourceId, (Object)resource);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reEnterShared(ResourceType resourceType, long resourceId) {
        this.stateHolder.incrementActiveClients(this);
        try {
            boolean bl = this.reEnter((LongObjectMap<LockResource>)this.localShared(resourceType), resourceId);
            return bl;
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reEnterExclusive(ResourceType resourceType, long resourceId) {
        this.stateHolder.incrementActiveClients(this);
        try {
            boolean bl = this.reEnter((LongObjectMap<LockResource>)this.localExclusive(resourceType), resourceId);
            return bl;
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    private boolean reEnter(LongObjectMap<LockResource> localLocks, long resourceId) {
        LockResource resource = (LockResource)localLocks.get(resourceId);
        if (resource != null) {
            resource.acquireReference();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseShared(ResourceType resourceType, long ... resourceIds) {
        this.stateHolder.incrementActiveClients(this);
        try {
            MutableLongObjectMap<LockResource> localLocks = this.localShared(resourceType);
            for (long resourceId : resourceIds) {
                LockResource resource = (LockResource)localLocks.get(resourceId);
                if (resource.releaseReference() != 0) continue;
                localLocks.remove(resourceId);
                this.manager.releaseReadLock(new LockResource(resourceType, resourceId), this.lockTransaction);
            }
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseExclusive(ResourceType resourceType, long ... resourceIds) {
        this.stateHolder.incrementActiveClients(this);
        try {
            MutableLongObjectMap<LockResource> localLocks = this.localExclusive(resourceType);
            for (long resourceId : resourceIds) {
                LockResource resource = (LockResource)localLocks.get(resourceId);
                if (resource.releaseReference() != 0) continue;
                localLocks.remove(resourceId);
                this.manager.releaseWriteLock(new LockResource(resourceType, resourceId), this.lockTransaction);
            }
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    @Override
    public void prepare() {
        this.stateHolder.prepare(this);
    }

    @Override
    public void stop() {
        if (this.stateHolder.stopClient()) {
            this.terminateAllWaitersAndWaitForClientsToLeave();
            this.releaseLocks();
        }
    }

    private void terminateAllWaitersAndWaitForClientsToLeave() {
        this.terminateAllWaiters();
        while (this.stateHolder.hasActiveClients()) {
            this.terminateAllWaiters();
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(20L));
        }
    }

    @Override
    public void close() {
        this.stateHolder.closeClient();
        this.terminateAllWaitersAndWaitForClientsToLeave();
        this.releaseLocks();
    }

    private void releaseLocks() {
        this.exclusiveLocks.forEachValue(this.typeWriteReleaser);
        this.sharedLocks.forEachValue(this.typeReadReleaser);
        this.exclusiveLocks.clear();
        this.sharedLocks.clear();
    }

    private void terminateAllWaiters() {
        this.manager.accept((Visitor<RWLock, RuntimeException>)((Visitor)lock -> {
            lock.terminateLockRequestsForLockTransaction(this.lockTransaction);
            return false;
        }));
    }

    @Override
    public int getLockSessionId() {
        return this.lockTransaction.getId();
    }

    public Stream<ActiveLock> activeLocks() {
        ArrayList<ActiveLock> locks = new ArrayList<ActiveLock>();
        this.exclusiveLocks.forEachKeyValue(CommunityLockClient.collectActiveLocks(locks, ActiveLock.Factory.EXCLUSIVE_LOCK));
        this.sharedLocks.forEachKeyValue(CommunityLockClient.collectActiveLocks(locks, ActiveLock.Factory.SHARED_LOCK));
        return locks.stream();
    }

    @Override
    public long activeLockCount() {
        LockCounter counter = new LockCounter();
        this.exclusiveLocks.forEachKeyValue((IntObjectProcedure)counter);
        this.sharedLocks.forEachKeyValue((IntObjectProcedure)counter);
        return counter.locks;
    }

    private static IntObjectProcedure<LongObjectMap<LockResource>> collectActiveLocks(List<ActiveLock> locks, ActiveLock.Factory activeLock) {
        return (IntObjectProcedure & Serializable)(typeId, exclusive) -> {
            ResourceType resourceType = ResourceTypes.fromId(typeId);
            exclusive.forEachKeyValue((LongObjectProcedure & Serializable)(resourceId, lock) -> locks.add(activeLock.create(resourceType, resourceId)));
        };
    }

    private MutableLongObjectMap<LockResource> localShared(ResourceType resourceType) {
        return (MutableLongObjectMap)this.sharedLocks.getIfAbsentPut(resourceType.typeId(), LongObjectHashMap::new);
    }

    private MutableLongObjectMap<LockResource> localExclusive(ResourceType resourceType) {
        return (MutableLongObjectMap)this.exclusiveLocks.getIfAbsentPut(resourceType.typeId(), LongObjectHashMap::new);
    }

    public String toString() {
        return String.format("%s[%d]", this.getClass().getSimpleName(), this.getLockSessionId());
    }

    private static class LockCounter
    implements IntObjectProcedure<LongObjectMap<LockResource>> {
        long locks;

        private LockCounter() {
        }

        public void value(int key, LongObjectMap<LockResource> value) {
            this.locks += (long)value.size();
        }
    }
}

