/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.config;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Function;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.index.schema.config.EnvelopeSettings;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;

public final class SpaceFillingCurveSettingsFactory {
    private SpaceFillingCurveSettingsFactory() {
    }

    static SpaceFillingCurveSettings fromConfig(int maxBits, EnvelopeSettings envelopeSettings) {
        return new SpaceFillingCurveSettings.SettingsFromConfig(envelopeSettings.getCrs().getDimension(), maxBits, envelopeSettings.asEnvelope());
    }

    public static SpaceFillingCurveSettings fromGBPTree(File indexFile, PageCache pageCache, Function<ByteBuffer, String> onError) throws IOException {
        SpaceFillingCurveSettings.SettingsFromIndexHeader settings = new SpaceFillingCurveSettings.SettingsFromIndexHeader();
        GBPTree.readHeader((PageCache)pageCache, (File)indexFile, (Header.Reader)settings.headerReader(onError));
        if (settings.isFailed()) {
            throw new IOException(settings.getFailureMessage());
        }
        return settings;
    }
}

