/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.procedure.primitive.LongObjectProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.exceptions.index.IndexActivationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.index.CapableIndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.StoreIndexDescriptor;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.index.EntityUpdates;
import org.neo4j.kernel.impl.api.index.IndexMap;
import org.neo4j.kernel.impl.api.index.IndexMapReference;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexPopulationJobController;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyCreator;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexUpdaterMap;
import org.neo4j.kernel.impl.api.index.IndexingProvidersService;
import org.neo4j.kernel.impl.api.index.IndexingUpdateService;
import org.neo4j.kernel.impl.api.index.MultiPopulatorFactory;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingController;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingMode;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.transaction.state.IndexUpdates;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.values.storable.Value;

public class IndexingService
extends LifecycleAdapter
implements IndexingUpdateService,
IndexingProvidersService {
    private final IndexSamplingController samplingController;
    private final IndexProxyCreator indexProxyCreator;
    private final IndexStoreView storeView;
    private final IndexProviderMap providerMap;
    private final IndexMapReference indexMapRef;
    private final Iterable<StoreIndexDescriptor> indexDescriptors;
    private final Log log;
    private final TokenNameLookup tokenNameLookup;
    private final MultiPopulatorFactory multiPopulatorFactory;
    private final LogProvider logProvider;
    private final Monitor monitor;
    private final SchemaState schemaState;
    private final IndexPopulationJobController populationJobController;
    private final Map<Long, IndexProxy> indexesToDropAfterCompletedRecovery = new HashMap<Long, IndexProxy>();
    public static final Monitor NO_MONITOR = new MonitorAdapter();
    private volatile State state = State.NOT_STARTED;

    IndexingService(IndexProxyCreator indexProxyCreator, IndexProviderMap providerMap, IndexMapReference indexMapRef, IndexStoreView storeView, Iterable<StoreIndexDescriptor> indexDescriptors, IndexSamplingController samplingController, TokenNameLookup tokenNameLookup, JobScheduler scheduler, SchemaState schemaState, MultiPopulatorFactory multiPopulatorFactory, LogProvider logProvider, Monitor monitor) {
        this.indexProxyCreator = indexProxyCreator;
        this.providerMap = providerMap;
        this.indexMapRef = indexMapRef;
        this.storeView = storeView;
        this.indexDescriptors = indexDescriptors;
        this.samplingController = samplingController;
        this.tokenNameLookup = tokenNameLookup;
        this.schemaState = schemaState;
        this.multiPopulatorFactory = multiPopulatorFactory;
        this.logProvider = logProvider;
        this.monitor = monitor;
        this.populationJobController = new IndexPopulationJobController(scheduler);
        this.log = logProvider.getLog(this.getClass());
    }

    public void init() {
        this.validateDefaultProviderExisting();
        this.indexMapRef.modify(indexMap -> {
            EnumMap<InternalIndexState, List<IndexLogRecord>> indexStates = new EnumMap<InternalIndexState, List<IndexLogRecord>>(InternalIndexState.class);
            for (StoreIndexDescriptor indexDescriptor : this.indexDescriptors) {
                IndexProxy indexProxy;
                IndexProvider.Descriptor providerDescriptor = indexDescriptor.providerDescriptor();
                IndexProvider provider = this.providerMap.lookup(providerDescriptor);
                InternalIndexState initialState = provider.getInitialState(indexDescriptor);
                indexStates.computeIfAbsent(initialState, internalIndexState -> new ArrayList()).add(new IndexLogRecord(indexDescriptor));
                this.log.debug(this.indexStateInfo("init", initialState, indexDescriptor));
                switch (initialState) {
                    case ONLINE: {
                        this.monitor.initialState(indexDescriptor, InternalIndexState.ONLINE);
                        indexProxy = this.indexProxyCreator.createOnlineIndexProxy(indexDescriptor);
                        break;
                    }
                    case POPULATING: {
                        this.monitor.initialState(indexDescriptor, InternalIndexState.POPULATING);
                        indexProxy = this.indexProxyCreator.createRecoveringIndexProxy(indexDescriptor);
                        break;
                    }
                    case FAILED: {
                        this.monitor.initialState(indexDescriptor, InternalIndexState.FAILED);
                        IndexPopulationFailure failure = IndexPopulationFailure.failure(provider.getPopulationFailure(indexDescriptor));
                        indexProxy = this.indexProxyCreator.createFailedIndexProxy(indexDescriptor, failure);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("" + initialState);
                    }
                }
                indexMap.putIndexProxy(indexProxy);
            }
            this.logIndexStateSummary("init", indexStates);
            return indexMap;
        });
    }

    private void validateDefaultProviderExisting() {
        if (this.providerMap == null || this.providerMap.getDefaultProvider() == null) {
            throw new IllegalStateException("You cannot run the database without an index provider, please make sure that a valid provider (subclass of " + IndexProvider.class.getName() + ") is on your classpath.");
        }
    }

    public void start() {
        this.state = State.STARTING;
        this.performRecoveredIndexDropActions();
        this.indexMapRef.indexMapSnapshot().forEachIndexProxy(this.indexProxyOperation("refresh", (ThrowingConsumer<IndexProxy, Exception>)((ThrowingConsumer)IndexProxy::refresh)));
        LongObjectHashMap rebuildingDescriptors = new LongObjectHashMap();
        this.indexMapRef.modify(arg_0 -> this.lambda$start$3((MutableLongObjectMap)rebuildingDescriptors, arg_0));
        this.samplingController.recoverIndexSamples();
        this.samplingController.start();
        rebuildingDescriptors.forEachKeyValue((LongObjectProcedure & Serializable)(indexId, descriptor) -> {
            IndexProxy proxy;
            if (descriptor.type() != IndexDescriptor.Type.UNIQUE) {
                return;
            }
            try {
                proxy = this.getIndexProxy(indexId);
            }
            catch (IndexNotFoundKernelException e) {
                throw new IllegalStateException("What? This index was seen during recovery just now, why isn't it available now?", e);
            }
            this.monitor.awaitingPopulationOfRecoveredIndex((StoreIndexDescriptor)descriptor);
            this.awaitOnline(proxy);
        });
        this.state = State.RUNNING;
    }

    public void populateIndexesOfAllTypes(MutableLongObjectMap<StoreIndexDescriptor> rebuildingDescriptors, IndexMap indexMap) {
        HashMap<EntityType, MutableLongObjectMap> rebuildingDescriptorsByType = new HashMap<EntityType, MutableLongObjectMap>();
        for (StoreIndexDescriptor descriptor : rebuildingDescriptors) {
            rebuildingDescriptorsByType.computeIfAbsent(descriptor.schema().entityType(), type -> new LongObjectHashMap()).put(descriptor.getId(), (Object)descriptor);
        }
        for (Map.Entry descriptorToPopulate : rebuildingDescriptorsByType.entrySet()) {
            IndexPopulationJob populationJob = this.newIndexPopulationJob((EntityType)descriptorToPopulate.getKey());
            this.populate((MutableLongObjectMap<StoreIndexDescriptor>)((MutableLongObjectMap)descriptorToPopulate.getValue()), indexMap, populationJob);
        }
    }

    private void performRecoveredIndexDropActions() {
        this.indexesToDropAfterCompletedRecovery.values().forEach(index -> {
            try {
                index.drop();
            }
            catch (Exception e) {
                try {
                    index.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.indexesToDropAfterCompletedRecovery.clear();
    }

    private void populate(MutableLongObjectMap<StoreIndexDescriptor> rebuildingDescriptors, IndexMap indexMap, IndexPopulationJob populationJob) {
        rebuildingDescriptors.forEachKeyValue((LongObjectProcedure & Serializable)(indexId, descriptor) -> {
            IndexProxy proxy = this.indexProxyCreator.createPopulatingIndexProxy((StoreIndexDescriptor)descriptor, false, this.monitor, populationJob);
            proxy.start();
            indexMap.putIndexProxy(proxy);
        });
        this.startIndexPopulation(populationJob);
    }

    private void awaitOnline(IndexProxy proxy) {
        block7: while (true) {
            switch (1.$SwitchMap$org$neo4j$internal$kernel$api$InternalIndexState[proxy.getState().ordinal()]) {
                case 1: {
                    return;
                }
                case 2: {
                    throw new IllegalStateException("Index entered " + InternalIndexState.FAILED + " state while recovery waited for it to be fully populated");
                }
                case 3: {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        throw new IllegalStateException("Waiting for index to become ONLINE was interrupted", e);
                    }
                }
                continue block7;
            }
            break;
        }
        throw new IllegalStateException(proxy.getState().name());
    }

    public void shutdown() throws ExecutionException, InterruptedException {
        this.state = State.STOPPED;
        this.samplingController.stop();
        this.populationJobController.stop();
        this.closeAllIndexes();
    }

    public Register.DoubleLongRegister indexUpdatesAndSize(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        long indexId = this.indexMapRef.getOnlineIndexId(descriptor);
        Register.DoubleLongRegister output = Registers.newDoubleLongRegister();
        this.storeView.indexUpdatesAndSize(indexId, output);
        return output;
    }

    public double indexUniqueValuesPercentage(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        long indexId = this.indexMapRef.getOnlineIndexId(descriptor);
        Register.DoubleLongRegister output = Registers.newDoubleLongRegister();
        this.storeView.indexSample(indexId, output);
        long unique = output.readFirst();
        long size = output.readSecond();
        if (size == 0L) {
            return 1.0;
        }
        return (double)unique / (double)size;
    }

    @Override
    public void validateBeforeCommit(SchemaDescriptor index, Value[] tuple) {
        this.indexMapRef.validateBeforeCommit(index, tuple);
    }

    @Override
    public IndexProvider.Descriptor indexProviderForNameOrDefault(Optional<String> providerName) {
        if (providerName.isPresent()) {
            return this.providerMap.lookup(providerName.get()).getProviderDescriptor();
        }
        return this.providerMap.getDefaultProvider().getProviderDescriptor();
    }

    @Override
    public void apply(IndexUpdates updates) throws IOException, IndexEntryConflictException {
        if (this.state == State.NOT_STARTED) {
            this.apply(updates, IndexUpdateMode.RECOVERY);
        } else if (this.state == State.RUNNING || this.state == State.STARTING) {
            this.apply(updates, IndexUpdateMode.ONLINE);
        } else {
            throw new IllegalStateException("Can't apply index updates " + Iterables.asList((Iterable)updates) + " while indexing service is " + (Object)((Object)this.state));
        }
    }

    private void apply(Iterable<IndexEntryUpdate<SchemaDescriptor>> updates, IndexUpdateMode updateMode) throws IOException, IndexEntryConflictException {
        try (IndexUpdaterMap updaterMap = this.indexMapRef.createIndexUpdaterMap(updateMode);){
            for (IndexEntryUpdate<SchemaDescriptor> indexUpdate : updates) {
                this.processUpdate(updaterMap, indexUpdate);
            }
        }
    }

    @Override
    public Iterable<IndexEntryUpdate<SchemaDescriptor>> convertToIndexUpdates(EntityUpdates entityUpdates, EntityType type) {
        Set<SchemaDescriptor> relatedIndexes = this.indexMapRef.getRelatedIndexes(entityUpdates.entityTokensChanged(), entityUpdates.entityTokensUnchanged(), entityUpdates.propertiesChanged(), type);
        return entityUpdates.forIndexKeys(relatedIndexes, this.storeView, type);
    }

    public void createIndexes(StoreIndexDescriptor ... rules) throws IOException {
        IndexPopulationStarter populationStarter = new IndexPopulationStarter(rules);
        this.indexMapRef.modify(populationStarter);
        populationStarter.startPopulation();
    }

    private void processUpdate(IndexUpdaterMap updaterMap, IndexEntryUpdate<SchemaDescriptor> indexUpdate) throws IOException, IndexEntryConflictException {
        IndexUpdater updater = updaterMap.getUpdater(indexUpdate.indexKey().schema());
        if (updater != null) {
            updater.process(indexUpdate);
        }
    }

    public void dropIndex(StoreIndexDescriptor rule) {
        this.indexMapRef.modify(indexMap -> {
            long indexId = rule.getId();
            IndexProxy index = indexMap.removeIndexProxy(indexId);
            if (this.state == State.RUNNING) {
                assert (index != null) : "Index " + rule + " doesn't exists";
                index.drop();
            } else if (index != null) {
                this.indexesToDropAfterCompletedRecovery.put(indexId, index);
            }
            return indexMap;
        });
    }

    public void triggerIndexSampling(IndexSamplingMode mode) {
        this.log.info("Manual trigger for sampling all indexes [" + (Object)((Object)mode) + "]");
        this.samplingController.sampleIndexes(mode);
    }

    public void triggerIndexSampling(SchemaDescriptor descriptor, IndexSamplingMode mode) throws IndexNotFoundKernelException {
        String description = descriptor.userDescription(this.tokenNameLookup);
        this.log.info("Manual trigger for sampling index " + description + " [" + (Object)((Object)mode) + "]");
        this.samplingController.sampleIndex(this.indexMapRef.getIndexId(descriptor), mode);
    }

    private void dropRecoveringIndexes(IndexMap indexMap, LongIterable indexesToRebuild) {
        indexesToRebuild.forEach((LongProcedure & Serializable)idx -> {
            IndexProxy indexProxy = indexMap.removeIndexProxy(idx);
            assert (indexProxy != null);
            indexProxy.drop();
        });
    }

    public void activateIndex(long indexId) throws IndexNotFoundKernelException, IndexActivationFailedKernelException, IndexPopulationFailedKernelException {
        try {
            if (this.state == State.RUNNING) {
                IndexProxy index = this.getIndexProxy(indexId);
                index.awaitStoreScanCompleted();
                index.activate();
                this.log.info("Constraint %s is %s.", new Object[]{index.getDescriptor(), InternalIndexState.ONLINE.name()});
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new IndexActivationFailedKernelException(e, "Unable to activate index, thread was interrupted.");
        }
    }

    public IndexProxy getIndexProxy(long indexId) throws IndexNotFoundKernelException {
        return this.indexMapRef.getIndexProxy(indexId);
    }

    public IndexProxy getIndexProxy(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexMapRef.getIndexProxy(descriptor);
    }

    public long getIndexId(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexMapRef.getIndexId(descriptor);
    }

    public void validateIndex(long indexId) throws IndexNotFoundKernelException, IndexPopulationFailedKernelException, UniquePropertyValueValidationException {
        this.getIndexProxy(indexId).validate();
    }

    public void forceAll(IOLimiter limiter) {
        this.indexMapRef.indexMapSnapshot().forEachIndexProxy(this.indexProxyOperation("force", (ThrowingConsumer<IndexProxy, Exception>)((ThrowingConsumer)proxy -> proxy.force(limiter))));
    }

    private LongObjectProcedure<IndexProxy> indexProxyOperation(String name, ThrowingConsumer<IndexProxy, Exception> operation) {
        return (LongObjectProcedure & Serializable)(id, indexProxy) -> {
            try {
                operation.accept(indexProxy);
            }
            catch (Exception e) {
                try {
                    IndexProxy proxy = this.indexMapRef.getIndexProxy(id);
                    throw new UnderlyingStorageException("Unable to " + name + " " + proxy, e);
                }
                catch (IndexNotFoundKernelException indexNotFoundKernelException) {
                    // empty catch block
                }
            }
        };
    }

    private void closeAllIndexes() {
        this.indexMapRef.modify(indexMap -> {
            Iterable<IndexProxy> indexesToStop = indexMap.getAllIndexProxies();
            for (IndexProxy index : indexesToStop) {
                try {
                    index.close();
                }
                catch (Exception e) {
                    this.log.error("Unable to close index", (Throwable)e);
                }
            }
            return new IndexMap();
        });
    }

    public LongSet getIndexIds() {
        Iterable<IndexProxy> indexProxies = this.indexMapRef.getAllIndexProxies();
        LongHashSet indexIds = new LongHashSet();
        for (IndexProxy indexProxy : indexProxies) {
            indexIds.add(indexProxy.getDescriptor().getId());
        }
        return indexIds;
    }

    public ResourceIterator<File> snapshotIndexFiles() throws IOException {
        ArrayList<ResourceIterator<File>> snapshots = new ArrayList<ResourceIterator<File>>();
        for (IndexProxy indexProxy : this.indexMapRef.getAllIndexProxies()) {
            snapshots.add(indexProxy.snapshotFiles());
        }
        return Iterators.concatResourceIterators(snapshots.iterator());
    }

    private IndexPopulationJob newIndexPopulationJob(EntityType type) {
        MultipleIndexPopulator multiPopulator = this.multiPopulatorFactory.create(this.storeView, this.logProvider, type, this.schemaState);
        return new IndexPopulationJob(multiPopulator, this.monitor);
    }

    private void startIndexPopulation(IndexPopulationJob job) {
        this.populationJobController.startIndexPopulation(job);
    }

    private String indexStateInfo(String tag, InternalIndexState state, StoreIndexDescriptor descriptor) {
        return String.format("IndexingService.%s: index %d on %s is %s", tag, descriptor.getId(), descriptor.schema().userDescription(this.tokenNameLookup), state.name());
    }

    private void logIndexStateSummary(String method, Map<InternalIndexState, List<IndexLogRecord>> indexStates) {
        if (indexStates.isEmpty()) {
            return;
        }
        int mostPopularStateCount = Integer.MIN_VALUE;
        InternalIndexState mostPopularState = null;
        for (Map.Entry<InternalIndexState, List<IndexLogRecord>> indexStateEntry : indexStates.entrySet()) {
            if (indexStateEntry.getValue().size() <= mostPopularStateCount) continue;
            mostPopularState = indexStateEntry.getKey();
            mostPopularStateCount = indexStateEntry.getValue().size();
        }
        indexStates.remove(mostPopularState);
        for (Map.Entry<InternalIndexState, List<IndexLogRecord>> indexStateEntry : indexStates.entrySet()) {
            InternalIndexState state = indexStateEntry.getKey();
            List<IndexLogRecord> logRecords = indexStateEntry.getValue();
            for (IndexLogRecord logRecord : logRecords) {
                this.log.info(this.indexStateInfo(method, state, logRecord.getDescriptor()));
            }
        }
        this.log.info(String.format("IndexingService.%s: indexes not specifically mentioned above are %s", method, mostPopularState));
    }

    private /* synthetic */ IndexMap lambda$start$3(MutableLongObjectMap rebuildingDescriptors, IndexMap indexMap) {
        EnumMap<InternalIndexState, List<IndexLogRecord>> indexStates = new EnumMap<InternalIndexState, List<IndexLogRecord>>(InternalIndexState.class);
        indexMap.forEachIndexProxy((LongObjectProcedure<IndexProxy>)(LongObjectProcedure & Serializable)(indexId, proxy) -> {
            InternalIndexState state = proxy.getState();
            CapableIndexDescriptor descriptor = proxy.getDescriptor();
            indexStates.computeIfAbsent(state, internalIndexState -> new ArrayList()).add(new IndexLogRecord(descriptor));
            this.log.debug(this.indexStateInfo("start", state, descriptor));
            switch (state) {
                case ONLINE: {
                    break;
                }
                case POPULATING: {
                    rebuildingDescriptors.put(indexId, (Object)descriptor);
                    break;
                }
                case FAILED: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown state: " + state);
                }
            }
        });
        this.logIndexStateSummary("start", indexStates);
        this.dropRecoveringIndexes(indexMap, (LongIterable)rebuildingDescriptors.keySet());
        this.populateIndexesOfAllTypes((MutableLongObjectMap<StoreIndexDescriptor>)rebuildingDescriptors, indexMap);
        return indexMap;
    }

    private static final class IndexLogRecord {
        private final StoreIndexDescriptor descriptor;

        IndexLogRecord(StoreIndexDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public long getIndexId() {
            return this.descriptor.getId();
        }

        public StoreIndexDescriptor getDescriptor() {
            return this.descriptor;
        }
    }

    private final class IndexPopulationStarter
    implements Function<IndexMap, IndexMap> {
        private final StoreIndexDescriptor[] descriptors;
        private IndexPopulationJob nodePopulationJob;
        private IndexPopulationJob relationshipPopulationJob;

        IndexPopulationStarter(StoreIndexDescriptor[] descriptors) {
            this.descriptors = descriptors;
        }

        @Override
        public IndexMap apply(IndexMap indexMap) {
            for (StoreIndexDescriptor descriptor : this.descriptors) {
                IndexProxy index;
                if (IndexingService.this.state == State.NOT_STARTED) {
                    IndexingService.this.indexesToDropAfterCompletedRecovery.remove(descriptor.getId());
                }
                if ((index = indexMap.getIndexProxy(descriptor.getId())) != null && IndexingService.this.state == State.NOT_STARTED) {
                    indexMap.putIndexProxy(index);
                    continue;
                }
                boolean flipToTentative = descriptor.canSupportUniqueConstraint();
                if (IndexingService.this.state == State.RUNNING) {
                    if (descriptor.schema().entityType() == EntityType.NODE) {
                        this.nodePopulationJob = this.nodePopulationJob == null ? IndexingService.this.newIndexPopulationJob(EntityType.NODE) : this.nodePopulationJob;
                        index = IndexingService.this.indexProxyCreator.createPopulatingIndexProxy(descriptor, flipToTentative, IndexingService.this.monitor, this.nodePopulationJob);
                        index.start();
                    } else {
                        this.relationshipPopulationJob = this.relationshipPopulationJob == null ? IndexingService.this.newIndexPopulationJob(EntityType.RELATIONSHIP) : this.relationshipPopulationJob;
                        index = IndexingService.this.indexProxyCreator.createPopulatingIndexProxy(descriptor, flipToTentative, IndexingService.this.monitor, this.relationshipPopulationJob);
                        index.start();
                    }
                } else {
                    index = IndexingService.this.indexProxyCreator.createRecoveringIndexProxy(descriptor);
                }
                indexMap.putIndexProxy(index);
            }
            return indexMap;
        }

        void startPopulation() {
            if (this.nodePopulationJob != null) {
                IndexingService.this.startIndexPopulation(this.nodePopulationJob);
            }
            if (this.relationshipPopulationJob != null) {
                IndexingService.this.startIndexPopulation(this.relationshipPopulationJob);
            }
        }
    }

    public static class MonitorAdapter
    implements Monitor {
        @Override
        public void initialState(StoreIndexDescriptor descriptor, InternalIndexState state) {
        }

        @Override
        public void populationCompleteOn(StoreIndexDescriptor descriptor) {
        }

        @Override
        public void indexPopulationScanStarting() {
        }

        @Override
        public void indexPopulationScanComplete() {
        }

        @Override
        public void awaitingPopulationOfRecoveredIndex(StoreIndexDescriptor descriptor) {
        }
    }

    public static interface Monitor {
        public void initialState(StoreIndexDescriptor var1, InternalIndexState var2);

        public void populationCompleteOn(StoreIndexDescriptor var1);

        public void indexPopulationScanStarting();

        public void indexPopulationScanComplete();

        public void awaitingPopulationOfRecoveredIndex(StoreIndexDescriptor var1);
    }

    static enum State {
        NOT_STARTED,
        STARTING,
        RUNNING,
        STOPPED;

    }
}

