/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.kernel.impl.core.TokenHolder;
import org.neo4j.kernel.impl.core.TokenHolders;
import org.neo4j.kernel.impl.core.TokenNotFoundException;

public class NonTransactionalTokenNameLookup
implements TokenNameLookup {
    private final TokenHolders tokenHolders;

    public NonTransactionalTokenNameLookup(TokenHolders tokenHolders) {
        this.tokenHolders = tokenHolders;
    }

    public String labelGetName(int labelId) {
        return NonTransactionalTokenNameLookup.tokenById(this.tokenHolders.labelTokens(), labelId, "label");
    }

    public String relationshipTypeGetName(int relTypeId) {
        return NonTransactionalTokenNameLookup.tokenById(this.tokenHolders.relationshipTypeTokens(), relTypeId, "relationshipType");
    }

    public String propertyKeyGetName(int propertyKeyId) {
        return NonTransactionalTokenNameLookup.tokenById(this.tokenHolders.propertyKeyTokens(), propertyKeyId, "property");
    }

    private static String tokenById(TokenHolder tokenHolder, int tokenId, String tokenName) {
        try {
            return tokenHolder.getTokenById(tokenId).name();
        }
        catch (TokenNotFoundException tokenNotFoundException) {
            return String.format("%s[%d]", tokenName, tokenId);
        }
    }
}

