/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.ArrayList;
import java.util.Collection;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.ResourceManager;
import org.neo4j.kernel.api.exceptions.ResourceCloseFailureException;

public class CloseableResourceManager
implements ResourceManager {
    private Collection<AutoCloseable> closeableResources;

    @Override
    public final void registerCloseableResource(AutoCloseable closeable) {
        if (this.closeableResources == null) {
            this.closeableResources = new ArrayList<AutoCloseable>(8);
        }
        this.closeableResources.add(closeable);
    }

    @Override
    public final void unregisterCloseableResource(AutoCloseable closeable) {
        if (this.closeableResources != null) {
            this.closeableResources.remove(closeable);
        }
    }

    @Override
    public final void closeAllCloseableResources() {
        if (this.closeableResources != null) {
            Collection<AutoCloseable> resourcesToClose = this.closeableResources;
            this.closeableResources = null;
            IOUtils.closeAll(ResourceCloseFailureException.class, (AutoCloseable[])resourcesToClose.toArray(new AutoCloseable[0]));
        }
    }
}

