/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.internal.kernel.api.procs.QualifiedName;

class ProcedureHolder<T> {
    private final Map<QualifiedName, Integer> nameToId = new HashMap<QualifiedName, Integer>();
    private final ArrayList<T> store = new ArrayList();

    ProcedureHolder() {
    }

    T get(QualifiedName name) {
        Integer id = this.nameToId.get(name);
        if (id == null) {
            return null;
        }
        return this.store.get(id);
    }

    T get(int id) {
        return this.store.get(id);
    }

    void put(QualifiedName name, T item) {
        int id = this.store.size();
        this.store.add(item);
        this.nameToId.put(name, id);
    }

    int idOf(QualifiedName name) {
        return this.nameToId.get(name);
    }

    List<T> all() {
        return Collections.unmodifiableList(this.store);
    }
}

