/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;

public class ProcedureConfig {
    public static final String PROC_ALLOWED_SETTING_DEFAULT_NAME = "dbms.security.procedures.default_allowed";
    public static final String PROC_ALLOWED_SETTING_ROLES = "dbms.security.procedures.roles";
    private static final String ROLES_DELIMITER = ",";
    private static final String SETTING_DELIMITER = ";";
    private static final String MAPPING_DELIMITER = ":";
    private static final String PROCEDURE_DELIMITER = ",";
    private final String defaultValue;
    private final List<ProcMatcher> matchers;
    private final List<Pattern> accessPatterns;
    private final List<Pattern> whiteList;
    static final ProcedureConfig DEFAULT = new ProcedureConfig();

    private ProcedureConfig() {
        this.defaultValue = "";
        this.matchers = Collections.emptyList();
        this.accessPatterns = Collections.emptyList();
        this.whiteList = Collections.singletonList(ProcedureConfig.compilePattern("*"));
    }

    public ProcedureConfig(Config config) {
        this.defaultValue = config.getValue(PROC_ALLOWED_SETTING_DEFAULT_NAME).map(Object::toString).orElse("");
        String allowedRoles = config.getValue(PROC_ALLOWED_SETTING_ROLES).map(Object::toString).orElse("");
        this.matchers = Stream.of(allowedRoles.split(SETTING_DELIMITER)).map(procToRoleSpec -> procToRoleSpec.split(MAPPING_DELIMITER)).filter(spec -> ((String[])spec).length > 1).map(spec -> {
            String[] roles = (String[])Arrays.stream(spec[1].split(",")).map(String::trim).toArray(String[]::new);
            return new ProcMatcher(spec[0].trim(), roles);
        }).collect(Collectors.toList());
        this.accessPatterns = this.parseMatchers(GraphDatabaseSettings.procedure_unrestricted.name(), config, ",", ProcedureConfig::compilePattern);
        this.whiteList = this.parseMatchers(GraphDatabaseSettings.procedure_whitelist.name(), config, ",", ProcedureConfig::compilePattern);
    }

    private <T> List<T> parseMatchers(String configName, Config config, String delimiter, Function<String, T> matchFunc) {
        String fullAccessProcedures = config.getValue(configName).map(Object::toString).orElse("");
        if (fullAccessProcedures.isEmpty()) {
            return Collections.emptyList();
        }
        return Stream.of(fullAccessProcedures.split(delimiter)).map(matchFunc).collect(Collectors.toList());
    }

    String[] rolesFor(String procedureName) {
        String[] wildCardRoles = this.matchers.stream().filter(matcher -> matcher.matches(procedureName)).map(ProcMatcher::roles).reduce(new String[0], (acc, next) -> (String[])Stream.concat(Arrays.stream(acc), Arrays.stream(next)).toArray(String[]::new));
        if (wildCardRoles.length > 0) {
            return wildCardRoles;
        }
        return this.getDefaultValue();
    }

    boolean fullAccessFor(String procedureName) {
        return this.accessPatterns.stream().anyMatch(pattern -> pattern.matcher(procedureName).matches());
    }

    boolean isWhitelisted(String procedureName) {
        return this.whiteList.stream().anyMatch(pattern -> pattern.matcher(procedureName).matches());
    }

    private static Pattern compilePattern(String procedure) {
        procedure = procedure.trim().replaceAll("([\\[\\]\\\\?()^${}+|.])", "\\\\$1");
        return Pattern.compile(procedure.replaceAll("\\*", ".*"));
    }

    private String[] getDefaultValue() {
        String[] stringArray;
        if (this.defaultValue == null || this.defaultValue.isEmpty()) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.defaultValue;
        }
        return stringArray;
    }

    private static class ProcMatcher {
        private final Pattern pattern;
        private final String[] roles;

        private ProcMatcher(String procedurePattern, String[] roles) {
            this.pattern = Pattern.compile(procedurePattern.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*"));
            this.roles = roles;
        }

        boolean matches(String procedureName) {
            return this.pattern.matcher(procedureName).matches();
        }

        String[] roles() {
            return this.roles;
        }
    }
}

