/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.neo4j.collection.RawIterator;
import org.neo4j.function.Suppliers;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.CapableIndexReference;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.ExplicitIndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.procs.ProcedureHandle;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserAggregator;
import org.neo4j.internal.kernel.api.procs.UserFunctionHandle;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaUtil;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.api.ExplicitIndex;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.proc.BasicContext;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.api.txstate.ExplicitIndexTransactionState;
import org.neo4j.kernel.api.txstate.TransactionCountingStateVisitor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.ClockContext;
import org.neo4j.kernel.impl.api.CountsRecordState;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.security.OverriddenAccessMode;
import org.neo4j.kernel.impl.api.security.RestrictedAccessMode;
import org.neo4j.kernel.impl.api.store.DefaultCapableIndexReference;
import org.neo4j.kernel.impl.api.store.DefaultIndexReference;
import org.neo4j.kernel.impl.api.store.PropertyUtil;
import org.neo4j.kernel.impl.index.ExplicitIndexStore;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.register.Registers;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.LabelScanReader;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.storageengine.api.txstate.ReadableDiffSets;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.string.UTF8;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;

public class AllStoreHolder
extends Read {
    private final StorageStatement.Nodes nodes;
    private final StorageStatement.Groups groups;
    private final StorageStatement.Properties properties;
    private final StorageStatement.Relationships relationships;
    private final StorageStatement statement;
    private final StoreReadLayer storeReadLayer;
    private final ExplicitIndexStore explicitIndexStore;
    private final Suppliers.Lazy<ExplicitIndexTransactionState> explicitIndexes;
    private final Procedures procedures;
    private final SchemaState schemaState;

    public AllStoreHolder(StorageEngine engine, StorageStatement statement, KernelTransactionImplementation ktx, DefaultCursors cursors, ExplicitIndexStore explicitIndexStore, Procedures procedures, SchemaState schemaState) {
        super(cursors, ktx);
        this.storeReadLayer = engine.storeReadLayer();
        this.statement = statement;
        this.explicitIndexes = Suppliers.lazySingleton(ktx::explicitIndexTxState);
        this.nodes = statement.nodes();
        this.relationships = statement.relationships();
        this.groups = statement.groups();
        this.properties = statement.properties();
        this.explicitIndexStore = explicitIndexStore;
        this.procedures = procedures;
        this.schemaState = schemaState;
    }

    public boolean nodeExists(long reference) {
        this.ktx.assertOpen();
        if (this.hasTxStateWithChanges()) {
            TransactionState txState = this.txState();
            if (txState.nodeIsDeletedInThisTx(reference)) {
                return false;
            }
            if (txState.nodeIsAddedInThisTx(reference)) {
                return true;
            }
        }
        return this.storeReadLayer.nodeExists(reference);
    }

    public long countsForNode(int labelId) {
        long count = this.countsForNodeWithoutTxState(labelId);
        if (this.ktx.hasTxStateWithChanges()) {
            CountsRecordState counts = new CountsRecordState();
            try {
                TransactionState txState = this.ktx.txState();
                txState.accept(new TransactionCountingStateVisitor(TxStateVisitor.EMPTY, this.storeReadLayer, this.statement, txState, counts));
                if (counts.hasChanges()) {
                    count += counts.nodeCount(labelId, Registers.newDoubleLongRegister()).readSecond();
                }
            }
            catch (ConstraintValidationException | CreateConstraintFailureException e) {
                throw new IllegalArgumentException("Unexpected error: " + e.getMessage());
            }
        }
        return count;
    }

    public long countsForNodeWithoutTxState(int labelId) {
        return this.storeReadLayer.countsForNode(labelId);
    }

    public long countsForRelationship(int startLabelId, int typeId, int endLabelId) {
        long count = this.countsForRelationshipWithoutTxState(startLabelId, typeId, endLabelId);
        if (this.ktx.hasTxStateWithChanges()) {
            CountsRecordState counts = new CountsRecordState();
            try {
                TransactionState txState = this.ktx.txState();
                txState.accept(new TransactionCountingStateVisitor(TxStateVisitor.EMPTY, this.storeReadLayer, this.statement, txState, counts));
                if (counts.hasChanges()) {
                    count += counts.relationshipCount(startLabelId, typeId, endLabelId, Registers.newDoubleLongRegister()).readSecond();
                }
            }
            catch (ConstraintValidationException | CreateConstraintFailureException e) {
                throw new IllegalArgumentException("Unexpected error: " + e.getMessage());
            }
        }
        return count;
    }

    public long countsForRelationshipWithoutTxState(int startLabelId, int typeId, int endLabelId) {
        return this.storeReadLayer.countsForRelationship(startLabelId, typeId, endLabelId);
    }

    public boolean relationshipExists(long reference) {
        this.ktx.assertOpen();
        if (this.hasTxStateWithChanges()) {
            TransactionState txState = this.txState();
            if (txState.relationshipIsDeletedInThisTx(reference)) {
                return false;
            }
            if (txState.relationshipIsAddedInThisTx(reference)) {
                return true;
            }
        }
        return this.storeReadLayer.relationshipExists(reference);
    }

    @Override
    long graphPropertiesReference() {
        return this.statement.getGraphPropertyReference();
    }

    @Override
    IndexReader indexReader(IndexReference index) throws IndexNotFoundKernelException {
        SchemaIndexDescriptor schemaIndexDescriptor = index.isUnique() ? SchemaIndexDescriptorFactory.uniqueForLabel(index.label(), index.properties()) : SchemaIndexDescriptorFactory.forLabel(index.label(), index.properties());
        return this.statement.getIndexReader(schemaIndexDescriptor);
    }

    @Override
    LabelScanReader labelScanReader() {
        return this.statement.getLabelScanReader();
    }

    @Override
    ExplicitIndex explicitNodeIndex(String indexName) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        return ((ExplicitIndexTransactionState)this.explicitIndexes.get()).nodeChanges(indexName);
    }

    @Override
    ExplicitIndex explicitRelationshipIndex(String indexName) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        return ((ExplicitIndexTransactionState)this.explicitIndexes.get()).relationshipChanges(indexName);
    }

    public String[] nodeExplicitIndexesGetAll() {
        this.ktx.assertOpen();
        return this.explicitIndexStore.getAllNodeIndexNames();
    }

    public String[] relationshipExplicitIndexesGetAll() {
        this.ktx.assertOpen();
        return this.explicitIndexStore.getAllRelationshipIndexNames();
    }

    @Override
    public CapableIndexReference index(int label, int ... properties) {
        LabelSchemaDescriptor descriptor;
        this.ktx.assertOpen();
        try {
            descriptor = SchemaDescriptorFactory.forLabel(label, properties);
        }
        catch (IllegalArgumentException ignore) {
            return CapableIndexReference.NO_INDEX;
        }
        SchemaIndexDescriptor indexDescriptor = this.storeReadLayer.indexGetForSchema((SchemaDescriptor)descriptor);
        if (this.ktx.hasTxStateWithChanges()) {
            ReadableDiffSets<SchemaIndexDescriptor> diffSets = this.ktx.txState().indexDiffSetsByLabel(label);
            if (indexDescriptor != null) {
                if (diffSets.isRemoved(indexDescriptor)) {
                    return CapableIndexReference.NO_INDEX;
                }
                return this.indexGetCapability(indexDescriptor);
            }
            Iterator fromTxState = Iterators.filter((Predicate)SchemaDescriptor.equalTo((SchemaDescriptor)descriptor), diffSets.apply((Iterator<SchemaIndexDescriptor>)Iterators.emptyResourceIterator()));
            if (fromTxState.hasNext()) {
                return DefaultCapableIndexReference.fromDescriptor((SchemaIndexDescriptor)fromTxState.next());
            }
            return CapableIndexReference.NO_INDEX;
        }
        return indexDescriptor != null ? this.indexGetCapability(indexDescriptor) : CapableIndexReference.NO_INDEX;
    }

    public Iterator<IndexReference> indexesGetForLabel(int labelId) {
        this.sharedOptimisticLock(ResourceTypes.LABEL, labelId);
        this.ktx.assertOpen();
        Iterator<SchemaIndexDescriptor> iterator = this.storeReadLayer.indexesGetForLabel(labelId);
        if (this.ktx.hasTxStateWithChanges()) {
            iterator = this.ktx.txState().indexDiffSetsByLabel(labelId).apply(iterator);
        }
        return Iterators.map(DefaultIndexReference::fromDescriptor, iterator);
    }

    public Iterator<IndexReference> indexesGetAll() {
        this.ktx.assertOpen();
        Iterator<SchemaIndexDescriptor> iterator = this.storeReadLayer.indexesGetAll();
        if (this.ktx.hasTxStateWithChanges()) {
            iterator = this.ktx.txState().indexChanges().apply(this.storeReadLayer.indexesGetAll());
        }
        return Iterators.map(indexDescriptor -> {
            this.sharedOptimisticLock(ResourceTypes.LABEL, indexDescriptor.schema().keyId());
            return DefaultIndexReference.fromDescriptor(indexDescriptor);
        }, iterator);
    }

    public InternalIndexState indexGetState(IndexReference index) throws IndexNotFoundKernelException {
        this.assertValidIndex(index);
        this.sharedOptimisticLock(ResourceTypes.LABEL, index.label());
        this.ktx.assertOpen();
        return this.indexGetState(this.indexDescriptor(index));
    }

    public PopulationProgress indexGetPopulationProgress(IndexReference index) throws IndexNotFoundKernelException {
        this.sharedOptimisticLock(ResourceTypes.LABEL, index.label());
        this.ktx.assertOpen();
        SchemaIndexDescriptor descriptor = this.indexDescriptor(index);
        if (this.ktx.hasTxStateWithChanges() && this.checkIndexState(descriptor, this.ktx.txState().indexDiffSetsByLabel(index.label()))) {
            return PopulationProgress.NONE;
        }
        return this.storeReadLayer.indexGetPopulationProgress(descriptor.schema());
    }

    public Long indexGetOwningUniquenessConstraintId(IndexReference index) {
        this.sharedOptimisticLock(ResourceTypes.LABEL, index.label());
        this.ktx.assertOpen();
        return this.indexGetOwningUniquenessConstraintId(this.indexDescriptor(index));
    }

    public long indexGetCommittedId(IndexReference index) throws SchemaRuleNotFoundException {
        this.sharedOptimisticLock(ResourceTypes.LABEL, index.label());
        this.ktx.assertOpen();
        return this.storeReadLayer.indexGetCommittedId(this.indexDescriptor(index));
    }

    SchemaIndexDescriptor indexDescriptor(IndexReference index) {
        if (index.isUnique()) {
            return SchemaIndexDescriptorFactory.uniqueForLabel(index.label(), index.properties());
        }
        return SchemaIndexDescriptorFactory.forLabel(index.label(), index.properties());
    }

    public String indexGetFailure(IndexReference index) throws IndexNotFoundKernelException {
        return this.storeReadLayer.indexGetFailure((SchemaDescriptor)SchemaDescriptorFactory.forLabel(index.label(), index.properties()));
    }

    public double indexUniqueValuesSelectivity(IndexReference index) throws IndexNotFoundKernelException {
        this.acquireSharedLabelLock(new long[]{index.label()});
        this.ktx.assertOpen();
        return this.storeReadLayer.indexUniqueValuesPercentage((SchemaDescriptor)SchemaDescriptorFactory.forLabel(index.label(), index.properties()));
    }

    public long indexSize(IndexReference index) throws IndexNotFoundKernelException {
        this.acquireSharedLabelLock(new long[]{index.label()});
        this.ktx.assertOpen();
        return this.storeReadLayer.indexSize((SchemaDescriptor)SchemaDescriptorFactory.forLabel(index.label(), index.properties()));
    }

    CapableIndexReference indexGetCapability(SchemaIndexDescriptor schemaIndexDescriptor) {
        try {
            return this.storeReadLayer.indexReference(schemaIndexDescriptor);
        }
        catch (IndexNotFoundKernelException e) {
            throw new IllegalStateException("Could not find capability for index " + schemaIndexDescriptor, e);
        }
    }

    InternalIndexState indexGetState(SchemaIndexDescriptor descriptor) throws IndexNotFoundKernelException {
        if (this.ktx.hasTxStateWithChanges() && this.checkIndexState(descriptor, this.ktx.txState().indexDiffSetsByLabel(descriptor.schema().keyId()))) {
            return InternalIndexState.POPULATING;
        }
        return this.storeReadLayer.indexGetState(descriptor);
    }

    Long indexGetOwningUniquenessConstraintId(SchemaIndexDescriptor index) {
        return this.storeReadLayer.indexGetOwningUniquenessConstraintId(index);
    }

    SchemaIndexDescriptor indexGetForSchema(SchemaDescriptor descriptor) {
        SchemaIndexDescriptor indexDescriptor = this.storeReadLayer.indexGetForSchema(descriptor);
        Iterator rules = Iterators.iterator((Object)indexDescriptor);
        if (this.ktx.hasTxStateWithChanges()) {
            rules = Iterators.filter((Predicate)SchemaDescriptor.equalTo((SchemaDescriptor)descriptor), this.ktx.txState().indexDiffSetsByLabel(descriptor.keyId()).apply(rules));
        }
        return (SchemaIndexDescriptor)Iterators.singleOrNull((Iterator)rules);
    }

    private boolean checkIndexState(SchemaIndexDescriptor index, ReadableDiffSets<SchemaIndexDescriptor> diffSet) throws IndexNotFoundKernelException {
        if (diffSet.isAdded(index)) {
            return true;
        }
        if (diffSet.isRemoved(index)) {
            throw new IndexNotFoundKernelException(String.format("Index on %s has been dropped in this transaction.", index.userDescription(SchemaUtil.idTokenNameLookup)));
        }
        return false;
    }

    public Iterator<ConstraintDescriptor> constraintsGetForSchema(SchemaDescriptor descriptor) {
        this.sharedOptimisticLock(descriptor.keyType(), descriptor.keyId());
        this.ktx.assertOpen();
        Iterator<ConstraintDescriptor> constraints = this.storeReadLayer.constraintsGetForSchema(descriptor);
        if (this.ktx.hasTxStateWithChanges()) {
            return this.ktx.txState().constraintsChangesForSchema(descriptor).apply(constraints);
        }
        return constraints;
    }

    public boolean constraintExists(ConstraintDescriptor descriptor) {
        SchemaDescriptor schema = descriptor.schema();
        this.sharedOptimisticLock(schema.keyType(), schema.keyId());
        this.ktx.assertOpen();
        boolean inStore = this.storeReadLayer.constraintExists(descriptor);
        if (this.ktx.hasTxStateWithChanges()) {
            ReadableDiffSets<ConstraintDescriptor> diffSet = this.ktx.txState().constraintsChangesForSchema(descriptor.schema());
            return diffSet.isAdded(descriptor) || inStore && !diffSet.isRemoved(descriptor);
        }
        return inStore;
    }

    public Iterator<ConstraintDescriptor> constraintsGetForLabel(int labelId) {
        this.sharedOptimisticLock(ResourceTypes.LABEL, labelId);
        this.ktx.assertOpen();
        Iterator<ConstraintDescriptor> constraints = this.storeReadLayer.constraintsGetForLabel(labelId);
        if (this.ktx.hasTxStateWithChanges()) {
            return this.ktx.txState().constraintsChangesForLabel(labelId).apply(constraints);
        }
        return constraints;
    }

    public Iterator<ConstraintDescriptor> constraintsGetAll() {
        this.ktx.assertOpen();
        Iterator<ConstraintDescriptor> constraints = this.storeReadLayer.constraintsGetAll();
        if (this.ktx.hasTxStateWithChanges()) {
            constraints = this.ktx.txState().constraintsChanges().apply(constraints);
        }
        return Iterators.map(constraintDescriptor -> {
            SchemaDescriptor schema = constraintDescriptor.schema();
            this.ktx.statementLocks().pessimistic().acquireShared(this.ktx.lockTracer(), schema.keyType(), schema.keyId());
            return constraintDescriptor;
        }, constraints);
    }

    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(int typeId) {
        this.sharedOptimisticLock(ResourceTypes.RELATIONSHIP_TYPE, typeId);
        this.ktx.assertOpen();
        Iterator<ConstraintDescriptor> constraints = this.storeReadLayer.constraintsGetForRelationshipType(typeId);
        if (this.ktx.hasTxStateWithChanges()) {
            return this.ktx.txState().constraintsChangesForRelationshipType(typeId).apply(constraints);
        }
        return constraints;
    }

    @Override
    PageCursor nodePage(long reference) {
        return this.nodes.openPageCursorForReading(reference);
    }

    @Override
    PageCursor relationshipPage(long reference) {
        return this.relationships.openPageCursorForReading(reference);
    }

    @Override
    PageCursor groupPage(long reference) {
        return this.groups.openPageCursorForReading(reference);
    }

    @Override
    PageCursor propertyPage(long reference) {
        return this.properties.openPageCursorForReading(reference);
    }

    @Override
    PageCursor stringPage(long reference) {
        return this.properties.openStringPageCursor(reference);
    }

    @Override
    PageCursor arrayPage(long reference) {
        return this.properties.openArrayPageCursor(reference);
    }

    @Override
    RecordCursor<DynamicRecord> labelCursor() {
        return this.nodes.newLabelCursor();
    }

    @Override
    void node(NodeRecord record, long reference, PageCursor pageCursor) {
        this.nodes.getRecordByCursor(reference, record, RecordLoad.CHECK, pageCursor);
    }

    @Override
    void relationship(RelationshipRecord record, long reference, PageCursor pageCursor) {
        this.relationships.getRecordByCursor(reference, record, RecordLoad.CHECK, pageCursor);
    }

    @Override
    void relationshipFull(RelationshipRecord record, long reference, PageCursor pageCursor) {
        this.relationships.getRecordByCursor(reference, record, RecordLoad.FORCE, pageCursor);
    }

    @Override
    void property(PropertyRecord record, long reference, PageCursor pageCursor) {
        this.properties.getRecordByCursor(reference, record, RecordLoad.FORCE, pageCursor);
    }

    @Override
    void group(RelationshipGroupRecord record, long reference, PageCursor page) {
        this.groups.getRecordByCursor(reference, record, RecordLoad.FORCE, page);
    }

    @Override
    long nodeHighMark() {
        return this.nodes.getHighestPossibleIdInUse();
    }

    @Override
    long relationshipHighMark() {
        return this.relationships.getHighestPossibleIdInUse();
    }

    @Override
    TextValue string(DefaultPropertyCursor cursor, long reference, PageCursor page) {
        ByteBuffer buffer = cursor.buffer = this.properties.loadString(reference, cursor.buffer, page);
        buffer.flip();
        return Values.stringValue((String)UTF8.decode((byte[])buffer.array(), (int)0, (int)buffer.limit()));
    }

    @Override
    ArrayValue array(DefaultPropertyCursor cursor, long reference, PageCursor page) {
        ByteBuffer buffer = cursor.buffer = this.properties.loadArray(reference, cursor.buffer, page);
        buffer.flip();
        return PropertyUtil.readArrayFromBuffer(buffer);
    }

    boolean nodeExistsInStore(long id) {
        return this.storeReadLayer.nodeExists(id);
    }

    void getOrCreateNodeIndexConfig(String indexName, Map<String, String> customConfig) {
        this.explicitIndexStore.getOrCreateNodeIndexConfig(indexName, customConfig);
    }

    void getOrCreateRelationshipIndexConfig(String indexName, Map<String, String> customConfig) {
        this.explicitIndexStore.getOrCreateRelationshipIndexConfig(indexName, customConfig);
    }

    String indexGetFailure(SchemaIndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.storeReadLayer.indexGetFailure(descriptor.schema());
    }

    public UserFunctionHandle functionGet(QualifiedName name) {
        this.ktx.assertOpen();
        return this.procedures.function(name);
    }

    public ProcedureHandle procedureGet(QualifiedName name) throws ProcedureException {
        this.ktx.assertOpen();
        return this.procedures.procedure(name);
    }

    public Set<ProcedureSignature> proceduresGetAll() throws ProcedureException {
        this.ktx.assertOpen();
        return this.procedures.getAllProcedures();
    }

    public UserFunctionHandle aggregationFunctionGet(QualifiedName name) {
        this.ktx.assertOpen();
        return this.procedures.aggregationFunction(name);
    }

    public RawIterator<Object[], ProcedureException> procedureCallRead(int id, Object[] arguments) throws ProcedureException {
        AccessMode accessMode = this.ktx.securityContext().mode();
        if (!accessMode.allowsReads()) {
            throw accessMode.onViolation(String.format("Read operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
        return this.callProcedure(id, arguments, (AccessMode)new RestrictedAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    public RawIterator<Object[], ProcedureException> procedureCallReadOverride(int id, Object[] arguments) throws ProcedureException {
        return this.callProcedure(id, arguments, (AccessMode)new OverriddenAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    public RawIterator<Object[], ProcedureException> procedureCallWrite(int id, Object[] arguments) throws ProcedureException {
        AccessMode accessMode = this.ktx.securityContext().mode();
        if (!accessMode.allowsWrites()) {
            throw accessMode.onViolation(String.format("Write operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
        return this.callProcedure(id, arguments, (AccessMode)new RestrictedAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.TOKEN_WRITE));
    }

    public RawIterator<Object[], ProcedureException> procedureCallWriteOverride(int id, Object[] arguments) throws ProcedureException {
        return this.callProcedure(id, arguments, (AccessMode)new OverriddenAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.TOKEN_WRITE));
    }

    public RawIterator<Object[], ProcedureException> procedureCallSchema(int id, Object[] arguments) throws ProcedureException {
        AccessMode accessMode = this.ktx.securityContext().mode();
        if (!accessMode.allowsSchemaWrites()) {
            throw accessMode.onViolation(String.format("Schema operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
        return this.callProcedure(id, arguments, (AccessMode)new RestrictedAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.FULL));
    }

    public RawIterator<Object[], ProcedureException> procedureCallSchemaOverride(int id, Object[] arguments) throws ProcedureException {
        return this.callProcedure(id, arguments, (AccessMode)new OverriddenAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.FULL));
    }

    public RawIterator<Object[], ProcedureException> procedureCallRead(QualifiedName name, Object[] arguments) throws ProcedureException {
        AccessMode accessMode = this.ktx.securityContext().mode();
        if (!accessMode.allowsReads()) {
            throw accessMode.onViolation(String.format("Read operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
        return this.callProcedure(name, arguments, (AccessMode)new RestrictedAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    public RawIterator<Object[], ProcedureException> procedureCallReadOverride(QualifiedName name, Object[] arguments) throws ProcedureException {
        return this.callProcedure(name, arguments, (AccessMode)new OverriddenAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    public RawIterator<Object[], ProcedureException> procedureCallWrite(QualifiedName name, Object[] arguments) throws ProcedureException {
        AccessMode accessMode = this.ktx.securityContext().mode();
        if (!accessMode.allowsWrites()) {
            throw accessMode.onViolation(String.format("Write operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
        return this.callProcedure(name, arguments, (AccessMode)new RestrictedAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.TOKEN_WRITE));
    }

    public RawIterator<Object[], ProcedureException> procedureCallWriteOverride(QualifiedName name, Object[] arguments) throws ProcedureException {
        return this.callProcedure(name, arguments, (AccessMode)new OverriddenAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.TOKEN_WRITE));
    }

    public RawIterator<Object[], ProcedureException> procedureCallSchema(QualifiedName name, Object[] arguments) throws ProcedureException {
        AccessMode accessMode = this.ktx.securityContext().mode();
        if (!accessMode.allowsSchemaWrites()) {
            throw accessMode.onViolation(String.format("Schema operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
        return this.callProcedure(name, arguments, (AccessMode)new RestrictedAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.FULL));
    }

    public RawIterator<Object[], ProcedureException> procedureCallSchemaOverride(QualifiedName name, Object[] arguments) throws ProcedureException {
        return this.callProcedure(name, arguments, (AccessMode)new OverriddenAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.FULL));
    }

    public AnyValue functionCall(int id, AnyValue[] arguments) throws ProcedureException {
        if (!this.ktx.securityContext().mode().allowsReads()) {
            throw this.ktx.securityContext().mode().onViolation(String.format("Read operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
        return this.callFunction(id, arguments, (AccessMode)new RestrictedAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    public AnyValue functionCall(QualifiedName name, AnyValue[] arguments) throws ProcedureException {
        if (!this.ktx.securityContext().mode().allowsReads()) {
            throw this.ktx.securityContext().mode().onViolation(String.format("Read operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
        return this.callFunction(name, arguments, (AccessMode)new RestrictedAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    public AnyValue functionCallOverride(int id, AnyValue[] arguments) throws ProcedureException {
        return this.callFunction(id, arguments, (AccessMode)new OverriddenAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    public AnyValue functionCallOverride(QualifiedName name, AnyValue[] arguments) throws ProcedureException {
        return this.callFunction(name, arguments, (AccessMode)new OverriddenAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    public UserAggregator aggregationFunction(int id) throws ProcedureException {
        if (!this.ktx.securityContext().mode().allowsReads()) {
            throw this.ktx.securityContext().mode().onViolation(String.format("Read operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
        return this.aggregationFunction(id, (AccessMode)new RestrictedAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    public UserAggregator aggregationFunction(QualifiedName name) throws ProcedureException {
        if (!this.ktx.securityContext().mode().allowsReads()) {
            throw this.ktx.securityContext().mode().onViolation(String.format("Read operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
        return this.aggregationFunction(name, (AccessMode)new RestrictedAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    public UserAggregator aggregationFunctionOverride(int id) throws ProcedureException {
        return this.aggregationFunction(id, (AccessMode)new OverriddenAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    public UserAggregator aggregationFunctionOverride(QualifiedName name) throws ProcedureException {
        return this.aggregationFunction(name, (AccessMode)new OverriddenAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    public ValueMapper<Object> valueMapper() {
        return this.procedures.valueMapper();
    }

    public <K, V> V schemaStateGetOrCreate(K key, Function<K, V> creator) {
        return this.schemaState.getOrCreate(key, creator);
    }

    public <K, V> V schemaStateGet(K key) {
        return this.schemaState.get(key);
    }

    public void schemaStateFlush() {
        this.schemaState.clear();
    }

    private RawIterator<Object[], ProcedureException> callProcedure(int id, Object[] input, AccessMode override) throws ProcedureException {
        RawIterator<Object[], ProcedureException> procedureCall;
        this.ktx.assertOpen();
        SecurityContext procedureSecurityContext = this.ktx.securityContext().withMode(override);
        try (KernelTransaction.Revertable ignore = this.ktx.overrideWith(procedureSecurityContext);
             KernelStatement statement = this.ktx.acquireStatement();){
            procedureCall = this.procedures.callProcedure((Context)this.populateProcedureContext(procedureSecurityContext), id, input, (ResourceTracker)statement);
        }
        return this.createIterator(procedureSecurityContext, procedureCall);
    }

    private RawIterator<Object[], ProcedureException> callProcedure(QualifiedName name, Object[] input, AccessMode override) throws ProcedureException {
        RawIterator<Object[], ProcedureException> procedureCall;
        this.ktx.assertOpen();
        SecurityContext procedureSecurityContext = this.ktx.securityContext().withMode(override);
        try (KernelTransaction.Revertable ignore = this.ktx.overrideWith(procedureSecurityContext);
             KernelStatement statement = this.ktx.acquireStatement();){
            procedureCall = this.procedures.callProcedure((Context)this.populateProcedureContext(procedureSecurityContext), name, input, (ResourceTracker)statement);
        }
        return this.createIterator(procedureSecurityContext, procedureCall);
    }

    private RawIterator<Object[], ProcedureException> createIterator(final SecurityContext procedureSecurityContext, final RawIterator<Object[], ProcedureException> procedureCall) {
        return new RawIterator<Object[], ProcedureException>(){

            public boolean hasNext() throws ProcedureException {
                try (KernelTransaction.Revertable ignore = AllStoreHolder.this.ktx.overrideWith(procedureSecurityContext);){
                    boolean bl = procedureCall.hasNext();
                    return bl;
                }
            }

            public Object[] next() throws ProcedureException {
                try (KernelTransaction.Revertable ignore = AllStoreHolder.this.ktx.overrideWith(procedureSecurityContext);){
                    Object[] objectArray = (Object[])procedureCall.next();
                    return objectArray;
                }
            }
        };
    }

    private AnyValue callFunction(int id, AnyValue[] input, AccessMode mode) throws ProcedureException {
        this.ktx.assertOpen();
        try (KernelTransaction.Revertable ignore = this.ktx.overrideWith(this.ktx.securityContext().withMode(mode));){
            AnyValue anyValue = this.procedures.callFunction((Context)this.populateFunctionContext(), id, input);
            return anyValue;
        }
    }

    private AnyValue callFunction(QualifiedName name, AnyValue[] input, AccessMode mode) throws ProcedureException {
        this.ktx.assertOpen();
        try (KernelTransaction.Revertable ignore = this.ktx.overrideWith(this.ktx.securityContext().withMode(mode));){
            AnyValue anyValue = this.procedures.callFunction((Context)this.populateFunctionContext(), name, input);
            return anyValue;
        }
    }

    private UserAggregator aggregationFunction(int id, AccessMode mode) throws ProcedureException {
        this.ktx.assertOpen();
        try (KernelTransaction.Revertable ignore = this.ktx.overrideWith(this.ktx.securityContext().withMode(mode));){
            UserAggregator userAggregator = this.procedures.createAggregationFunction((Context)this.populateAggregationContext(), id);
            return userAggregator;
        }
    }

    private UserAggregator aggregationFunction(QualifiedName name, AccessMode mode) throws ProcedureException {
        this.ktx.assertOpen();
        try (KernelTransaction.Revertable ignore = this.ktx.overrideWith(this.ktx.securityContext().withMode(mode));){
            UserAggregator userAggregator = this.procedures.createAggregationFunction((Context)this.populateAggregationContext(), name);
            return userAggregator;
        }
    }

    private BasicContext populateFunctionContext() {
        BasicContext ctx = new BasicContext();
        ctx.put(Context.KERNEL_TRANSACTION, this.ktx);
        ctx.put(Context.THREAD, Thread.currentThread());
        ClockContext clocks = this.ktx.clocks();
        ctx.put(Context.SYSTEM_CLOCK, clocks.systemClock());
        ctx.put(Context.STATEMENT_CLOCK, clocks.statementClock());
        ctx.put(Context.TRANSACTION_CLOCK, clocks.transactionClock());
        return ctx;
    }

    private BasicContext populateAggregationContext() {
        BasicContext ctx = new BasicContext();
        ctx.put(Context.KERNEL_TRANSACTION, this.ktx);
        ctx.put(Context.THREAD, Thread.currentThread());
        return ctx;
    }

    private BasicContext populateProcedureContext(SecurityContext procedureSecurityContext) {
        BasicContext ctx = new BasicContext();
        ctx.put(Context.KERNEL_TRANSACTION, this.ktx);
        ctx.put(Context.THREAD, Thread.currentThread());
        ctx.put(Context.SECURITY_CONTEXT, procedureSecurityContext);
        return ctx;
    }

    private void assertValidIndex(IndexReference index) throws IndexNotFoundKernelException {
        if (index == CapableIndexReference.NO_INDEX) {
            throw new IndexNotFoundKernelException("No index was found");
        }
    }
}

