/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.Arrays;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.storageengine.api.schema.IndexSampler;

public class FusionIndexSampler
implements IndexSampler {
    private final IndexSampler[] samplers;

    public FusionIndexSampler(IndexSampler ... samplers) {
        this.samplers = samplers;
    }

    @Override
    public IndexSample sampleIndex() throws IndexNotFoundKernelException {
        IndexSample[] samples = new IndexSample[this.samplers.length];
        for (int i = 0; i < this.samplers.length; ++i) {
            samples[i] = this.samplers[i].sampleIndex();
        }
        return FusionIndexSampler.combineSamples(samples);
    }

    static IndexSample combineSamples(IndexSample ... samples) {
        return new IndexSample(Arrays.stream(samples).mapToLong(IndexSample::indexSize).sum(), Arrays.stream(samples).mapToLong(IndexSample::uniqueValues).sum(), Arrays.stream(samples).mapToLong(IndexSample::sampleSize).sum());
    }
}

