/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexReader;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexUpdater;
import org.neo4j.storageengine.api.schema.IndexReader;

class FusionIndexAccessor
extends FusionIndexBase<IndexAccessor>
implements IndexAccessor {
    private final long indexId;
    private final SchemaIndexDescriptor descriptor;
    private final FusionIndexProvider.DropAction dropAction;

    FusionIndexAccessor(IndexAccessor[] accessors, FusionIndexProvider.Selector selector, long indexId, SchemaIndexDescriptor descriptor, FusionIndexProvider.DropAction dropAction) {
        super(accessors, selector);
        this.indexId = indexId;
        this.descriptor = descriptor;
        this.dropAction = dropAction;
    }

    @Override
    public void drop() throws IOException {
        FusionIndexAccessor.forAll(IndexAccessor::drop, this.instances);
        this.dropAction.drop(this.indexId);
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        return new FusionIndexUpdater(this.instancesAs(IndexUpdater.class, accessor -> accessor.newUpdater(mode)), this.selector);
    }

    @Override
    public void force(IOLimiter ioLimiter) throws IOException {
        FusionIndexAccessor.forAll(accessor -> accessor.force(ioLimiter), this.instances);
    }

    @Override
    public void refresh() throws IOException {
        FusionIndexAccessor.forAll(IndexAccessor::refresh, this.instances);
    }

    @Override
    public void close() throws IOException {
        FusionIndexAccessor.forAll(IndexAccessor::close, this.instances);
    }

    @Override
    public IndexReader newReader() {
        return new FusionIndexReader(this.instancesAs(IndexReader.class, IndexAccessor::newReader), this.selector, this.descriptor);
    }

    @Override
    public BoundedIterable<Long> newAllEntriesReader() {
        final BoundedIterable[] entries = this.instancesAs(BoundedIterable.class, IndexAccessor::newAllEntriesReader);
        return new BoundedIterable<Long>(){

            @Override
            public long maxCount() {
                long[] maxCounts = new long[entries.length];
                long sum = 0L;
                for (int i = 0; i < entries.length; ++i) {
                    maxCounts[i] = entries[i].maxCount();
                    sum += maxCounts[i];
                }
                return this.existsUnknownMaxCount(maxCounts) ? -1L : sum;
            }

            private boolean existsUnknownMaxCount(long ... maxCounts) {
                for (long maxCount : maxCounts) {
                    if (maxCount != -1L) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void close() throws Exception {
                FusionIndexBase.forAll(AutoCloseable::close, entries);
            }

            @Override
            public Iterator<Long> iterator() {
                return Iterables.concat((Iterable[])entries).iterator();
            }
        };
    }

    @Override
    public ResourceIterator<File> snapshotFiles() throws IOException {
        ArrayList snapshots = new ArrayList();
        FusionIndexAccessor.forAll(accessor -> snapshots.add(accessor.snapshotFiles()), this.instances);
        return Iterators.concatResourceIterators(snapshots.iterator());
    }

    @Override
    public void verifyDeferredConstraints(PropertyAccessor propertyAccessor) throws IndexEntryConflictException, IOException {
        for (IndexAccessor accessor : (IndexAccessor[])this.instances) {
            accessor.verifyDeferredConstraints(propertyAccessor);
        }
    }

    @Override
    public boolean isDirty() {
        return Arrays.stream(this.instances).anyMatch(IndexAccessor::isDirty);
    }
}

