/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.impl.index.schema.TemporalIndexCache;
import org.neo4j.kernel.impl.index.schema.TemporalIndexPopulator;

public class TemporalIndexPopulatingUpdater
extends TemporalIndexCache<IndexUpdater, IOException>
implements IndexUpdater {
    TemporalIndexPopulatingUpdater(TemporalIndexPopulator populator, PropertyAccessor propertyAccessor) {
        super(new PartFactory(populator, propertyAccessor));
    }

    @Override
    public void process(IndexEntryUpdate<?> update) throws IOException, IndexEntryConflictException {
        switch (update.updateMode()) {
            case ADDED: {
                ((IndexUpdater)this.select(update.values()[0].valueGroup())).process(update);
                break;
            }
            case CHANGED: {
                IndexUpdater from = (IndexUpdater)this.select(update.beforeValues()[0].valueGroup());
                IndexUpdater to = (IndexUpdater)this.select(update.values()[0].valueGroup());
                if (from == to) {
                    from.process(update);
                    break;
                }
                from.process(IndexEntryUpdate.remove(update.getEntityId(), update.indexKey(), update.beforeValues()));
                to.process(IndexEntryUpdate.add(update.getEntityId(), update.indexKey(), update.values()));
                break;
            }
            case REMOVED: {
                ((IndexUpdater)this.select(update.values()[0].valueGroup())).process(update);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown update mode");
            }
        }
    }

    @Override
    public void close() throws IOException, IndexEntryConflictException {
        for (IndexUpdater part : this) {
            part.close();
        }
    }

    static class PartFactory
    implements TemporalIndexCache.Factory<IndexUpdater, IOException> {
        private final TemporalIndexPopulator populator;
        private PropertyAccessor propertyAccessor;

        PartFactory(TemporalIndexPopulator populator, PropertyAccessor propertyAccessor) {
            this.populator = populator;
            this.propertyAccessor = propertyAccessor;
        }

        @Override
        public IndexUpdater newDate() throws IOException {
            return ((TemporalIndexPopulator.PartPopulator)this.populator.date()).newPopulatingUpdater(this.propertyAccessor);
        }

        @Override
        public IndexUpdater newLocalDateTime() throws IOException {
            return ((TemporalIndexPopulator.PartPopulator)this.populator.localDateTime()).newPopulatingUpdater(this.propertyAccessor);
        }

        @Override
        public IndexUpdater newZonedDateTime() throws IOException {
            return ((TemporalIndexPopulator.PartPopulator)this.populator.zonedDateTime()).newPopulatingUpdater(this.propertyAccessor);
        }

        @Override
        public IndexUpdater newLocalTime() throws IOException {
            return ((TemporalIndexPopulator.PartPopulator)this.populator.localTime()).newPopulatingUpdater(this.propertyAccessor);
        }

        @Override
        public IndexUpdater newZonedTime() throws IOException {
            return ((TemporalIndexPopulator.PartPopulator)this.populator.zonedTime()).newPopulatingUpdater(this.propertyAccessor);
        }

        @Override
        public IndexUpdater newDuration() throws IOException {
            return ((TemporalIndexPopulator.PartPopulator)this.populator.duration()).newPopulatingUpdater(this.propertyAccessor);
        }
    }
}

