/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.cursor.RawCursor;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexReader;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.kernel.impl.index.schema.SpatialHitIndexProgressor;
import org.neo4j.kernel.impl.index.schema.SpatialLayout;
import org.neo4j.kernel.impl.index.schema.SpatialSchemaKey;
import org.neo4j.kernel.impl.index.schema.fusion.BridgingIndexProgressor;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.values.storable.Value;

public class SpatialIndexPartReader<VALUE extends NativeSchemaValue>
extends NativeSchemaIndexReader<SpatialSchemaKey, VALUE> {
    private final SpatialLayout spatial;
    private final SpaceFillingCurveConfiguration configuration;

    SpatialIndexPartReader(GBPTree<SpatialSchemaKey, VALUE> tree, Layout<SpatialSchemaKey, VALUE> layout, IndexSamplingConfig samplingConfig, SchemaIndexDescriptor descriptor, SpaceFillingCurveConfiguration configuration) {
        super(tree, layout, samplingConfig, descriptor);
        this.spatial = (SpatialLayout)layout;
        this.configuration = configuration;
    }

    @Override
    void validateQuery(IndexOrder indexOrder, IndexQuery[] predicates) {
        if (predicates.length != 1) {
            throw new UnsupportedOperationException("Spatial index doesn't handle composite queries");
        }
        if (indexOrder != IndexOrder.NONE) {
            throw new UnsupportedOperationException(String.format("Tried to query index with unsupported order %s. Supported orders for query %s are %s.", indexOrder, Arrays.toString(predicates), IndexOrder.NONE));
        }
    }

    @Override
    boolean initializeRangeForQuery(SpatialSchemaKey treeKeyFrom, SpatialSchemaKey treeKeyTo, IndexQuery[] predicates) {
        throw new UnsupportedOperationException("Cannot initialize 1D range in multidimensional spatial index reader");
    }

    @Override
    public PrimitiveLongResourceIterator query(IndexQuery ... predicates) {
        NodeValueIterator nodeValueIterator = new NodeValueIterator();
        this.query(nodeValueIterator, IndexOrder.NONE, predicates);
        return nodeValueIterator;
    }

    @Override
    public void query(IndexProgressor.NodeValueClient cursor, IndexOrder indexOrder, IndexQuery ... predicates) {
        this.validateQuery(indexOrder, predicates);
        IndexQuery predicate = predicates[0];
        switch (predicate.type()) {
            case exists: {
                this.startSeekForExists(cursor, predicate);
                break;
            }
            case exact: {
                this.startSeekForExact(cursor, ((IndexQuery.ExactPredicate)predicate).value(), predicate);
                break;
            }
            case range: {
                IndexQuery.GeometryRangePredicate rangePredicate = (IndexQuery.GeometryRangePredicate)predicate;
                if (!rangePredicate.crs().equals((Object)this.spatial.crs)) {
                    throw new IllegalArgumentException("IndexQuery on spatial index with mismatching CoordinateReferenceSystem: " + rangePredicate.crs() + " != " + this.spatial.crs);
                }
                this.startSeekForRange(cursor, rangePredicate, predicates);
                break;
            }
            default: {
                throw new IllegalArgumentException("IndexQuery of type " + predicate.type() + " is not supported.");
            }
        }
    }

    private void startSeekForExists(IndexProgressor.NodeValueClient client, IndexQuery ... predicates) {
        SpatialSchemaKey treeKeyFrom = (SpatialSchemaKey)((Object)this.layout.newKey());
        SpatialSchemaKey treeKeyTo = (SpatialSchemaKey)((Object)this.layout.newKey());
        treeKeyFrom.initAsLowest();
        treeKeyTo.initAsHighest();
        this.startSeekForInitializedRange(client, treeKeyFrom, treeKeyTo, predicates, false);
    }

    private void startSeekForExact(IndexProgressor.NodeValueClient client, Value value, IndexQuery ... predicates) {
        SpatialSchemaKey treeKeyFrom = (SpatialSchemaKey)((Object)this.layout.newKey());
        SpatialSchemaKey treeKeyTo = (SpatialSchemaKey)((Object)this.layout.newKey());
        treeKeyFrom.from(Long.MIN_VALUE, value);
        treeKeyTo.from(Long.MAX_VALUE, value);
        this.startSeekForInitializedRange(client, treeKeyFrom, treeKeyTo, predicates, false);
    }

    private void startSeekForRange(IndexProgressor.NodeValueClient client, IndexQuery.GeometryRangePredicate rangePredicate, IndexQuery[] query) {
        try {
            BridgingIndexProgressor multiProgressor = new BridgingIndexProgressor(client, this.descriptor.schema().getPropertyIds());
            client.initialize(this.descriptor, multiProgressor, query);
            SpaceFillingCurve curve = this.spatial.getSpaceFillingCurve();
            double[] from = rangePredicate.from() == null ? null : rangePredicate.from().coordinate();
            double[] to = rangePredicate.to() == null ? null : rangePredicate.to().coordinate();
            List ranges = curve.getTilesIntersectingEnvelope(from, to, this.configuration);
            for (SpaceFillingCurve.LongRange range : ranges) {
                SpatialSchemaKey treeKeyFrom = (SpatialSchemaKey)((Object)this.layout.newKey());
                SpatialSchemaKey treeKeyTo = (SpatialSchemaKey)((Object)this.layout.newKey());
                treeKeyFrom.fromDerivedValue(Long.MIN_VALUE, range.min);
                treeKeyTo.fromDerivedValue(Long.MAX_VALUE, range.max + 1L);
                RawCursor seeker = this.makeIndexSeeker(treeKeyFrom, treeKeyTo);
                SpatialHitIndexProgressor hitProgressor = new SpatialHitIndexProgressor(seeker, client, this.openSeekers);
                multiProgressor.initialize(this.descriptor, hitProgressor, query);
            }
        }
        catch (IllegalArgumentException e) {
            client.initialize(this.descriptor, IndexProgressor.EMPTY, query);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    void startSeekForInitializedRange(IndexProgressor.NodeValueClient client, SpatialSchemaKey treeKeyFrom, SpatialSchemaKey treeKeyTo, IndexQuery[] query, boolean needFilter) {
        if (this.layout.compare((Object)treeKeyFrom, (Object)treeKeyTo) > 0) {
            client.initialize(this.descriptor, IndexProgressor.EMPTY, query);
            return;
        }
        try {
            RawCursor seeker = this.makeIndexSeeker(treeKeyFrom, treeKeyTo);
            SpatialHitIndexProgressor hitProgressor = new SpatialHitIndexProgressor(seeker, client, this.openSeekers);
            client.initialize(this.descriptor, hitProgressor, query);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean hasFullValuePrecision(IndexQuery ... predicates) {
        return false;
    }
}

