/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.neo4j.kernel.impl.util.CopyOnWriteHashMap;
import org.neo4j.values.storable.CoordinateReferenceSystem;

class SpatialIndexCache<T, E extends Exception>
implements Iterable<T> {
    private final Factory<T, E> factory;
    private Map<CoordinateReferenceSystem, T> spatials = new CopyOnWriteHashMap<CoordinateReferenceSystem, T>();

    SpatialIndexCache(Factory<T, E> factory) {
        this.factory = factory;
    }

    T uncheckedSelect(CoordinateReferenceSystem crs) {
        try {
            return this.select(crs);
        }
        catch (Exception t) {
            throw new RuntimeException(t);
        }
    }

    T select(CoordinateReferenceSystem crs) throws E {
        T part = this.spatials.get(crs);
        if (part == null && (part = this.factory.newSpatial(crs)) != null) {
            this.spatials.put(crs, part);
        }
        return part;
    }

    <RESULT> RESULT selectOrElse(CoordinateReferenceSystem crs, Function<T, RESULT> function, RESULT orElse) {
        T part = this.spatials.get(crs);
        if (part == null) {
            return orElse;
        }
        return function.apply(part);
    }

    void loadAll() {
        Iterator crsIterator = CoordinateReferenceSystem.all();
        while (crsIterator.hasNext()) {
            this.uncheckedSelect((CoordinateReferenceSystem)crsIterator.next());
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.spatials.values().iterator();
    }

    static interface Factory<T, E extends Exception> {
        public T newSpatial(CoordinateReferenceSystem var1) throws E;
    }
}

