/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.File;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexMeta;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.PopulationProgress;

public class PopulatingIndexProxy
implements IndexProxy {
    private final IndexMeta indexMeta;
    private final IndexPopulationJob job;
    private final MultipleIndexPopulator.IndexPopulation indexPopulation;

    PopulatingIndexProxy(IndexMeta indexMeta, IndexPopulationJob job, MultipleIndexPopulator.IndexPopulation indexPopulation) {
        this.indexMeta = indexMeta;
        this.job = job;
        this.indexPopulation = indexPopulation;
    }

    @Override
    public void start() {
    }

    @Override
    public IndexUpdater newUpdater(final IndexUpdateMode mode) {
        switch (mode) {
            case ONLINE: 
            case RECOVERY: {
                return new PopulatingIndexUpdater(){

                    @Override
                    public void process(IndexEntryUpdate<?> update) {
                        PopulatingIndexProxy.this.job.update(update);
                    }
                };
            }
        }
        return new PopulatingIndexUpdater(){

            @Override
            public void process(IndexEntryUpdate<?> update) {
                throw new IllegalArgumentException("Unsupported update mode: " + (Object)((Object)mode));
            }
        };
    }

    @Override
    public void drop() {
        this.job.cancelPopulation(this.indexPopulation);
    }

    @Override
    public SchemaIndexDescriptor getDescriptor() {
        return this.indexMeta.indexDescriptor();
    }

    @Override
    public SchemaDescriptor schema() {
        return this.indexMeta.indexDescriptor().schema();
    }

    @Override
    public IndexProvider.Descriptor getProviderDescriptor() {
        return this.indexMeta.providerDescriptor();
    }

    @Override
    public InternalIndexState getState() {
        return InternalIndexState.POPULATING;
    }

    @Override
    public IndexCapability getIndexCapability() {
        return this.indexMeta.indexCapability();
    }

    @Override
    public void force(IOLimiter ioLimiter) {
    }

    @Override
    public void refresh() {
    }

    @Override
    public void close() {
        this.job.cancelPopulation(this.indexPopulation);
    }

    @Override
    public IndexReader newReader() throws IndexNotFoundKernelException {
        throw new IndexNotFoundKernelException("Index is still populating: " + this.job);
    }

    @Override
    public boolean awaitStoreScanCompleted() throws InterruptedException {
        this.job.awaitCompletion();
        return true;
    }

    @Override
    public void activate() {
        throw new IllegalStateException("Cannot activate index while it is still populating: " + this.job);
    }

    @Override
    public void validate() {
        throw new IllegalStateException("Cannot validate index while it is still populating: " + this.job);
    }

    @Override
    public long getIndexId() {
        return this.indexMeta.getIndexId();
    }

    @Override
    public ResourceIterator<File> snapshotFiles() {
        return Iterators.emptyResourceIterator();
    }

    @Override
    public IndexPopulationFailure getPopulationFailure() throws IllegalStateException {
        throw new IllegalStateException(this + " is POPULATING");
    }

    @Override
    public PopulationProgress getIndexPopulationProgress() {
        return this.job.getPopulationProgress();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[job:" + this.job + "]";
    }

    private abstract class PopulatingIndexUpdater
    implements IndexUpdater {
        private PopulatingIndexUpdater() {
        }

        @Override
        public void close() {
        }
    }
}

