/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.impl.api.index.IndexMap;
import org.neo4j.kernel.impl.api.index.IndexMapSnapshotProvider;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexUpdaterMap;

public class IndexMapReference
implements IndexMapSnapshotProvider {
    private volatile IndexMap indexMap = new IndexMap();

    @Override
    public IndexMap indexMapSnapshot() {
        return this.indexMap.clone();
    }

    public synchronized <E extends Exception> void modify(ThrowingFunction<IndexMap, IndexMap, E> modifier) throws E {
        IndexMap snapshot = this.indexMapSnapshot();
        this.indexMap = (IndexMap)modifier.apply((Object)snapshot);
    }

    public IndexProxy getIndexProxy(long indexId) throws IndexNotFoundKernelException {
        IndexProxy proxy = this.indexMap.getIndexProxy(indexId);
        if (proxy == null) {
            throw new IndexNotFoundKernelException("No index for index id " + indexId + " exists.");
        }
        return proxy;
    }

    public IndexProxy getIndexProxy(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        IndexProxy proxy = this.indexMap.getIndexProxy(descriptor);
        if (proxy == null) {
            throw new IndexNotFoundKernelException("No index for " + descriptor + " exists.");
        }
        return proxy;
    }

    public long getIndexId(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        IndexProxy proxy = this.indexMap.getIndexProxy(descriptor);
        if (proxy == null) {
            throw new IndexNotFoundKernelException("No index for " + descriptor + " exists.");
        }
        return this.indexMap.getIndexId(descriptor);
    }

    public long getOnlineIndexId(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        IndexProxy proxy = this.getIndexProxy(descriptor);
        switch (proxy.getState()) {
            case ONLINE: {
                return this.indexMap.getIndexId(descriptor);
            }
        }
        throw new IndexNotFoundKernelException("Expected index on " + descriptor + " to be online.");
    }

    public Iterable<IndexProxy> getAllIndexProxies() {
        return this.indexMap.getAllIndexProxies();
    }

    public Iterable<SchemaDescriptor> getRelatedIndexes(long[] changedLabels, long[] unchangedLabels, PrimitiveIntSet properties) {
        return this.indexMap.getRelatedIndexes(changedLabels, unchangedLabels, properties);
    }

    public IndexUpdaterMap createIndexUpdaterMap(IndexUpdateMode mode) {
        return new IndexUpdaterMap(this.indexMap, mode);
    }
}

