/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.File;
import java.io.IOException;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.impl.api.index.AbstractSwallowingIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexCountsRemover;
import org.neo4j.kernel.impl.api.index.IndexMeta;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class FailedIndexProxy
extends AbstractSwallowingIndexProxy {
    protected final IndexPopulator populator;
    private final String indexUserDescription;
    private final IndexCountsRemover indexCountsRemover;
    private final Log log;

    FailedIndexProxy(IndexMeta indexMeta, String indexUserDescription, IndexPopulator populator, IndexPopulationFailure populationFailure, IndexCountsRemover indexCountsRemover, LogProvider logProvider) {
        super(indexMeta, populationFailure);
        this.populator = populator;
        this.indexUserDescription = indexUserDescription;
        this.indexCountsRemover = indexCountsRemover;
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public void drop() throws IOException {
        this.indexCountsRemover.remove();
        String message = "FailedIndexProxy#drop index on " + this.indexUserDescription + " dropped due to:\n" + this.getPopulationFailure().asString();
        this.log.info(message);
        this.populator.drop();
    }

    @Override
    public InternalIndexState getState() {
        return InternalIndexState.FAILED;
    }

    @Override
    public boolean awaitStoreScanCompleted() throws IndexPopulationFailedKernelException {
        throw this.getPopulationFailure().asIndexPopulationFailure(this.getDescriptor().schema(), this.indexUserDescription);
    }

    @Override
    public void activate() {
        throw new UnsupportedOperationException("Cannot activate a failed index.");
    }

    @Override
    public void validate() throws IndexPopulationFailedKernelException {
        throw this.getPopulationFailure().asIndexPopulationFailure(this.getDescriptor().schema(), this.indexUserDescription);
    }

    @Override
    public ResourceIterator<File> snapshotFiles() {
        return Iterators.emptyResourceIterator();
    }
}

