/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.File;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.api.index.IndexProvider;

public abstract class IndexDirectoryStructure {
    private static final IndexDirectoryStructure NO_DIRECTORY_STRUCTURE = new IndexDirectoryStructure(){

        @Override
        public File rootDirectory() {
            return null;
        }

        @Override
        public File directoryForIndex(long indexId) {
            return null;
        }
    };
    public static final Factory NONE = descriptor -> NO_DIRECTORY_STRUCTURE;

    static File baseSchemaIndexFolder(File databaseStoreDir) {
        return FileUtils.path((File)databaseStoreDir, (String[])new String[]{"schema", "index"});
    }

    public static Factory directoriesByProviderKey(File databaseStoreDir) {
        return descriptor -> new SubDirectoryByIndexId(FileUtils.path((File)IndexDirectoryStructure.baseSchemaIndexFolder(databaseStoreDir), (String[])new String[]{IndexDirectoryStructure.fileNameFriendly(descriptor.getKey())}));
    }

    public static Factory directoriesByProvider(File databaseStoreDir) {
        return descriptor -> new SubDirectoryByIndexId(FileUtils.path((File)IndexDirectoryStructure.baseSchemaIndexFolder(databaseStoreDir), (String[])new String[]{IndexDirectoryStructure.fileNameFriendly(descriptor)}));
    }

    public static Factory given(IndexDirectoryStructure directoryStructure) {
        return descriptor -> directoryStructure;
    }

    public static Factory directoriesBySubProvider(final IndexDirectoryStructure parentStructure) {
        return descriptor -> new IndexDirectoryStructure(){

            @Override
            public File rootDirectory() {
                return parentStructure.rootDirectory();
            }

            @Override
            public File directoryForIndex(long indexId) {
                return FileUtils.path((File)parentStructure.directoryForIndex(indexId), (String[])new String[]{IndexDirectoryStructure.fileNameFriendly(descriptor)});
            }
        };
    }

    private static String fileNameFriendly(String name) {
        return name.replaceAll("\\+", "_");
    }

    private static String fileNameFriendly(IndexProvider.Descriptor descriptor) {
        return IndexDirectoryStructure.fileNameFriendly(descriptor.getKey() + "-" + descriptor.getVersion());
    }

    public abstract File rootDirectory();

    public abstract File directoryForIndex(long var1);

    private static class SubDirectoryByIndexId
    extends IndexDirectoryStructure {
        private final File providerRootFolder;

        private SubDirectoryByIndexId(File providerRootFolder) {
            this.providerRootFolder = providerRootFolder;
        }

        @Override
        public File rootDirectory() {
            return this.providerRootFolder;
        }

        @Override
        public File directoryForIndex(long indexId) {
            return FileUtils.path((File)this.providerRootFolder, (String[])new String[]{String.valueOf(indexId)});
        }
    }

    public static interface Factory {
        public IndexDirectoryStructure forProvider(IndexProvider.Descriptor var1);
    }
}

