/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc.temporal;

import java.time.Clock;
import java.time.ZoneId;
import java.time.temporal.TemporalUnit;
import java.util.function.Supplier;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.impl.proc.temporal.TemporalFunction;
import org.neo4j.procedure.Description;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.MapValue;

@Description(value="Create a LocalDateTime instant.")
class LocalDateTimeFunction
extends TemporalFunction<LocalDateTimeValue> {
    LocalDateTimeFunction() {
        super(Neo4jTypes.NTLocalDateTime);
    }

    @Override
    protected LocalDateTimeValue now(Clock clock, String timezone) {
        return timezone == null ? LocalDateTimeValue.now((Clock)clock) : LocalDateTimeValue.now((Clock)clock, (String)timezone);
    }

    @Override
    protected LocalDateTimeValue parse(TextValue value, Supplier<ZoneId> defaultZone) {
        return LocalDateTimeValue.parse((TextValue)value);
    }

    @Override
    protected LocalDateTimeValue build(MapValue map, Supplier<ZoneId> defaultZone) {
        return LocalDateTimeValue.build((MapValue)map, defaultZone);
    }

    @Override
    protected LocalDateTimeValue select(AnyValue from, Supplier<ZoneId> defaultZone) {
        return LocalDateTimeValue.select((AnyValue)from, defaultZone);
    }

    @Override
    protected LocalDateTimeValue positionalCreate(AnyValue[] input) {
        if (input.length != 7) {
            throw new IllegalArgumentException("expected 7 arguments");
        }
        return LocalDateTimeValue.localDateTime((int)LocalDateTimeFunction.anInt("year", input[0]), (int)LocalDateTimeFunction.anInt("month", input[1]), (int)LocalDateTimeFunction.anInt("day", input[2]), (int)LocalDateTimeFunction.anInt("hour", input[3]), (int)LocalDateTimeFunction.anInt("minute", input[4]), (int)LocalDateTimeFunction.anInt("second", input[5]), (int)LocalDateTimeFunction.anInt("nanos", input[6]));
    }

    @Override
    protected LocalDateTimeValue truncate(TemporalUnit unit, TemporalValue input, MapValue fields, Supplier<ZoneId> defaultZone) {
        return LocalDateTimeValue.truncate((TemporalUnit)unit, (TemporalValue)input, (MapValue)fields, defaultZone);
    }
}

