/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.neo4j.collection.PrefetchingRawIterator;
import org.neo4j.collection.RawIterator;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.CallableUserAggregationFunction;
import org.neo4j.kernel.api.proc.CallableUserFunction;
import org.neo4j.kernel.impl.proc.ReflectiveProcedureCompiler;
import org.neo4j.logging.Log;

public class ProcedureJarLoader {
    private final ReflectiveProcedureCompiler compiler;
    private final Log log;

    public ProcedureJarLoader(ReflectiveProcedureCompiler compiler, Log log) {
        this.compiler = compiler;
        this.log = log;
    }

    public Callables loadProcedures(URL jar) throws Exception {
        return this.loadProcedures(jar, new URLClassLoader(new URL[]{jar}, this.getClass().getClassLoader()), new Callables());
    }

    public Callables loadProceduresFromDir(File root) throws IOException, KernelException {
        if (!root.exists()) {
            return Callables.empty();
        }
        Callables out = new Callables();
        URL[] jarFiles = (URL[])Stream.of(root.listFiles((dir, name) -> name.endsWith(".jar"))).map(this::toURL).toArray(URL[]::new);
        URLClassLoader loader = new URLClassLoader(jarFiles, this.getClass().getClassLoader());
        for (URL jarFile : jarFiles) {
            this.loadProcedures(jarFile, loader, out);
        }
        return out;
    }

    private Callables loadProcedures(URL jar, ClassLoader loader, Callables target) throws IOException, KernelException {
        RawIterator<Class<?>, IOException> classes = this.listClassesIn(jar, loader);
        while (classes.hasNext()) {
            Class next = (Class)classes.next();
            target.addAllProcedures(this.compiler.compileProcedure(next, Optional.empty(), false));
            target.addAllFunctions(this.compiler.compileFunction(next));
            target.addAllAggregationFunctions(this.compiler.compileAggregationFunction(next));
        }
        return target;
    }

    private URL toURL(File f) {
        try {
            return f.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private RawIterator<Class<?>, IOException> listClassesIn(final URL jar, final ClassLoader loader) throws IOException {
        final ZipInputStream zip = new ZipInputStream(jar.openStream());
        return new PrefetchingRawIterator<Class<?>, IOException>(){

            protected Class<?> fetchNextOrNull() throws IOException {
                try {
                    while (true) {
                        ZipEntry nextEntry;
                        if ((nextEntry = zip.getNextEntry()) == null) {
                            zip.close();
                            return null;
                        }
                        String name = nextEntry.getName();
                        if (!name.endsWith(".class")) continue;
                        String className = name.substring(0, name.length() - ".class".length()).replace('/', '.');
                        try {
                            Class<?> aClass = loader.loadClass(className);
                            aClass.getDeclaredMethods();
                            return aClass;
                        }
                        catch (Exception | NoClassDefFoundError | UnsatisfiedLinkError e) {
                            ProcedureJarLoader.this.log.warn("Failed to load `%s` from plugin jar `%s`: %s", new Object[]{className, jar.getFile(), e.getMessage()});
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException | RuntimeException e) {
                    zip.close();
                    throw e;
                }
            }
        };
    }

    public static class Callables {
        private final List<CallableProcedure> procedures = new ArrayList<CallableProcedure>();
        private final List<CallableUserFunction> functions = new ArrayList<CallableUserFunction>();
        private final List<CallableUserAggregationFunction> aggregationFunctions = new ArrayList<CallableUserAggregationFunction>();
        private static Callables EMPTY = new Callables();

        public void add(CallableProcedure proc) {
            this.procedures.add(proc);
        }

        public void add(CallableUserFunction func) {
            this.functions.add(func);
        }

        public List<CallableProcedure> procedures() {
            return this.procedures;
        }

        public List<CallableUserFunction> functions() {
            return this.functions;
        }

        public List<CallableUserAggregationFunction> aggregationFunctions() {
            return this.aggregationFunctions;
        }

        public void addAllProcedures(List<CallableProcedure> callableProcedures) {
            this.procedures.addAll(callableProcedures);
        }

        public void addAllFunctions(List<CallableUserFunction> callableFunctions) {
            this.functions.addAll(callableFunctions);
        }

        public void addAllAggregationFunctions(List<CallableUserAggregationFunction> callableFunctions) {
            this.aggregationFunctions.addAll(callableFunctions);
        }

        public static Callables empty() {
            return EMPTY;
        }
    }
}

