/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.helpers.collection.CastingIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.ExplicitIndexRead;
import org.neo4j.internal.kernel.api.ExplicitIndexWrite;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.AutoIndexingKernelException;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.ExplicitIndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorPredicates;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.exceptions.schema.UnableToValidateConstraintException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.explicitindex.AutoIndexing;
import org.neo4j.kernel.api.schema.constaints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.newapi.AllStoreHolder;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeValueIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.IndexTxStateUpdater;
import org.neo4j.kernel.impl.newapi.KernelToken;
import org.neo4j.kernel.impl.newapi.NodeSchemaMatcher;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class Operations
implements Write,
ExplicitIndexWrite {
    private final KernelTransactionImplementation ktx;
    private final AllStoreHolder allStoreHolder;
    private final KernelToken token;
    private final StorageStatement statement;
    private final AutoIndexing autoIndexing;
    private DefaultNodeCursor nodeCursor;
    private final IndexTxStateUpdater updater;
    private DefaultPropertyCursor propertyCursor;
    private DefaultRelationshipScanCursor relationshipCursor;
    private final DefaultCursors cursors;

    public Operations(AllStoreHolder allStoreHolder, IndexTxStateUpdater updater, StorageStatement statement, KernelTransactionImplementation ktx, KernelToken token, DefaultCursors cursors, AutoIndexing autoIndexing) {
        this.token = token;
        this.autoIndexing = autoIndexing;
        this.allStoreHolder = allStoreHolder;
        this.ktx = ktx;
        this.statement = statement;
        this.updater = updater;
        this.cursors = cursors;
    }

    public void initialize() {
        this.nodeCursor = this.cursors.allocateNodeCursor();
        this.propertyCursor = this.cursors.allocatePropertyCursor();
        this.relationshipCursor = this.cursors.allocateRelationshipScanCursor();
    }

    public long nodeCreate() {
        this.ktx.assertOpen();
        long nodeId = this.statement.reserveNode();
        this.ktx.txState().nodeDoCreate(nodeId);
        return nodeId;
    }

    public boolean nodeDelete(long node) throws AutoIndexingKernelException {
        this.ktx.assertOpen();
        if (this.ktx.hasTxStateWithChanges()) {
            if (this.ktx.txState().nodeIsAddedInThisTx(node)) {
                this.autoIndexing.nodes().entityRemoved(this, node);
                this.ktx.txState().nodeDoDelete(node);
                return true;
            }
            if (this.ktx.txState().nodeIsDeletedInThisTx(node)) {
                return false;
            }
        }
        this.ktx.locks().optimistic().acquireExclusive(this.ktx.lockTracer(), ResourceTypes.NODE, node);
        if (this.allStoreHolder.nodeExistsInStore(node)) {
            this.autoIndexing.nodes().entityRemoved(this, node);
            this.ktx.txState().nodeDoDelete(node);
            return true;
        }
        return false;
    }

    public long relationshipCreate(long sourceNode, int relationshipType, long targetNode) throws EntityNotFoundException {
        this.ktx.assertOpen();
        this.sharedRelationshipTypeLock(relationshipType);
        this.lockRelationshipNodes(sourceNode, targetNode);
        this.assertNodeExists(sourceNode);
        this.assertNodeExists(targetNode);
        long id = this.statement.reserveRelationship();
        this.ktx.txState().relationshipDoCreate(id, relationshipType, sourceNode, targetNode);
        return id;
    }

    public boolean relationshipDelete(long relationship) throws AutoIndexingKernelException {
        this.ktx.assertOpen();
        this.allStoreHolder.singleRelationship(relationship, this.relationshipCursor);
        if (this.relationshipCursor.next()) {
            this.lockRelationshipNodes(this.relationshipCursor.sourceNodeReference(), this.relationshipCursor.targetNodeReference());
            this.acquireExclusiveRelationshipLock(relationship);
            if (!this.allStoreHolder.relationshipExists(relationship)) {
                return false;
            }
            this.ktx.assertOpen();
            this.autoIndexing.relationships().entityRemoved(this, relationship);
            TransactionState txState = this.ktx.txState();
            if (txState.relationshipIsAddedInThisTx(relationship)) {
                txState.relationshipDoDeleteAddedInThisTx(relationship);
            } else {
                txState.relationshipDoDelete(relationship, this.relationshipCursor.getType(), this.relationshipCursor.sourceNodeReference(), this.relationshipCursor.targetNodeReference());
            }
            return true;
        }
        return false;
    }

    public boolean nodeAddLabel(long node, int nodeLabel) throws EntityNotFoundException, ConstraintValidationException {
        this.acquireSharedLabelLock(nodeLabel);
        this.acquireExclusiveNodeLock(node);
        this.ktx.assertOpen();
        this.singleNode(node);
        if (this.nodeCursor.labels().contains(nodeLabel)) {
            return false;
        }
        Iterator<ConstraintDescriptor> constraints = this.allStoreHolder.constraintsGetForLabel(nodeLabel);
        while (constraints.hasNext()) {
            IndexBackedConstraintDescriptor uniqueConstraint;
            IndexQuery.ExactPredicate[] propertyValues;
            ConstraintDescriptor constraint = constraints.next();
            if (!constraint.enforcesUniqueness() || (propertyValues = this.getAllPropertyValues((SchemaDescriptor)(uniqueConstraint = (IndexBackedConstraintDescriptor)constraint).schema(), -1, Values.NO_VALUE)) == null) continue;
            this.validateNoExistingNodeWithExactValues(uniqueConstraint, propertyValues, node);
        }
        this.ktx.txState().nodeDoAddLabel(nodeLabel, node);
        this.updater.onLabelChange(nodeLabel, this.nodeCursor, this.propertyCursor, IndexTxStateUpdater.LabelChangeType.ADDED_LABEL);
        return true;
    }

    private void singleNode(long node) throws EntityNotFoundException {
        this.allStoreHolder.singleNode(node, this.nodeCursor);
        if (!this.nodeCursor.next()) {
            throw new EntityNotFoundException(EntityType.NODE, node);
        }
    }

    private void singleRelationship(long relationship) throws EntityNotFoundException {
        this.allStoreHolder.singleRelationship(relationship, this.relationshipCursor);
        if (!this.relationshipCursor.next()) {
            throw new EntityNotFoundException(EntityType.RELATIONSHIP, relationship);
        }
    }

    private IndexQuery.ExactPredicate[] getAllPropertyValues(SchemaDescriptor schema, int changedPropertyKeyId, Value changedValue) {
        int k;
        int[] schemaPropertyIds = schema.getPropertyIds();
        IndexQuery.ExactPredicate[] values = new IndexQuery.ExactPredicate[schemaPropertyIds.length];
        int nMatched = 0;
        this.nodeCursor.properties(this.propertyCursor);
        while (this.propertyCursor.next()) {
            int nodePropertyId = this.propertyCursor.propertyKey();
            int k2 = ArrayUtils.indexOf((int[])schemaPropertyIds, (int)nodePropertyId);
            if (k2 < 0) continue;
            if (nodePropertyId != -1) {
                values[k2] = IndexQuery.exact((int)nodePropertyId, (Object)this.propertyCursor.propertyValue());
            }
            ++nMatched;
        }
        if (changedPropertyKeyId != -1 && (k = ArrayUtils.indexOf((int[])schemaPropertyIds, (int)changedPropertyKeyId)) >= 0) {
            values[k] = IndexQuery.exact((int)changedPropertyKeyId, (Object)changedValue);
            ++nMatched;
        }
        if (nMatched < values.length) {
            return null;
        }
        return values;
    }

    private void validateNoExistingNodeWithExactValues(IndexBackedConstraintDescriptor constraint, IndexQuery.ExactPredicate[] propertyValues, long modifiedNode) throws UniquePropertyValueValidationException, UnableToValidateConstraintException {
        try (DefaultNodeValueIndexCursor valueCursor = this.cursors.allocateNodeValueIndexCursor();){
            IndexDescriptor indexDescriptor = constraint.ownedIndexDescriptor();
            this.assertIndexOnline(indexDescriptor);
            int labelId = indexDescriptor.schema().getLabelId();
            this.ktx.locks().optimistic().acquireExclusive(this.ktx.lockTracer(), ResourceTypes.INDEX_ENTRY, ResourceTypes.indexEntryResourceId(labelId, propertyValues));
            this.allStoreHolder.nodeIndexSeek((IndexReference)this.allStoreHolder.indexGetCapability(indexDescriptor), valueCursor, IndexOrder.NONE, (IndexQuery[])propertyValues);
            if (valueCursor.next() && valueCursor.nodeReference() != modifiedNode) {
                throw new UniquePropertyValueValidationException(constraint, ConstraintValidationException.Phase.VALIDATION, new IndexEntryConflictException(valueCursor.nodeReference(), -1L, IndexQuery.asValueTuple((IndexQuery.ExactPredicate[])propertyValues)));
            }
        }
        catch (IndexNotApplicableKernelException | IndexNotFoundKernelException | IndexBrokenKernelException e) {
            throw new UnableToValidateConstraintException(constraint, (Throwable)e);
        }
    }

    private void assertIndexOnline(IndexDescriptor descriptor) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        switch (this.allStoreHolder.indexGetState(descriptor)) {
            case ONLINE: {
                return;
            }
        }
        throw new IndexBrokenKernelException(this.allStoreHolder.indexGetFailure(descriptor));
    }

    public boolean nodeRemoveLabel(long node, int nodeLabel) throws EntityNotFoundException {
        this.acquireExclusiveNodeLock(node);
        this.ktx.assertOpen();
        this.singleNode(node);
        if (!this.nodeCursor.labels().contains(nodeLabel)) {
            return false;
        }
        this.ktx.txState().nodeDoRemoveLabel(nodeLabel, node);
        this.updater.onLabelChange(nodeLabel, this.nodeCursor, this.propertyCursor, IndexTxStateUpdater.LabelChangeType.REMOVED_LABEL);
        return true;
    }

    public Value nodeSetProperty(long node, int propertyKey, Value value) throws EntityNotFoundException, ConstraintValidationException, AutoIndexingKernelException {
        this.acquireExclusiveNodeLock(node);
        this.ktx.assertOpen();
        this.singleNode(node);
        this.ktx.locks().optimistic().acquireShared(this.ktx.lockTracer(), ResourceTypes.LABEL, this.nodeCursor.labels().all());
        Iterator constraints = Iterators.filter((Predicate)SchemaDescriptorPredicates.hasProperty((int)propertyKey), this.allStoreHolder.constraintsGetAll());
        CastingIterator uniquenessConstraints = new CastingIterator(constraints, IndexBackedConstraintDescriptor.class);
        NodeSchemaMatcher.onMatchingSchema(uniquenessConstraints, this.nodeCursor, this.propertyCursor, propertyKey, (constraint, propertyIds) -> {
            Value previousValue;
            if (propertyIds.contains(propertyKey) && value.equals(previousValue = this.readNodeProperty(propertyKey))) {
                return;
            }
            this.validateNoExistingNodeWithExactValues((IndexBackedConstraintDescriptor)constraint, this.getAllPropertyValues((SchemaDescriptor)constraint.schema(), propertyKey, value), node);
        });
        Value existingValue = this.readNodeProperty(propertyKey);
        if (existingValue == Values.NO_VALUE) {
            this.autoIndexing.nodes().propertyAdded(this, node, propertyKey, value);
            this.ktx.txState().nodeDoAddProperty(node, propertyKey, value);
            this.updater.onPropertyAdd(this.nodeCursor, this.propertyCursor, propertyKey, value);
            return Values.NO_VALUE;
        }
        if (this.propertyHasChanged(value, existingValue)) {
            this.autoIndexing.nodes().propertyChanged(this, node, propertyKey, existingValue, value);
            this.ktx.txState().nodeDoChangeProperty(node, propertyKey, existingValue, value);
            this.updater.onPropertyChange(this.nodeCursor, this.propertyCursor, propertyKey, existingValue, value);
        }
        return existingValue;
    }

    public Value nodeRemoveProperty(long node, int propertyKey) throws EntityNotFoundException, AutoIndexingKernelException {
        this.acquireExclusiveNodeLock(node);
        this.ktx.assertOpen();
        this.singleNode(node);
        Value existingValue = this.readNodeProperty(propertyKey);
        if (existingValue != Values.NO_VALUE) {
            this.autoIndexing.nodes().propertyRemoved(this, node, propertyKey);
            this.ktx.txState().nodeDoRemoveProperty(node, propertyKey, existingValue);
            this.updater.onPropertyRemove(this.nodeCursor, this.propertyCursor, propertyKey, existingValue);
        }
        return existingValue;
    }

    public Value relationshipSetProperty(long relationship, int propertyKey, Value value) throws EntityNotFoundException, AutoIndexingKernelException {
        this.acquireExclusiveRelationshipLock(relationship);
        this.ktx.assertOpen();
        this.singleRelationship(relationship);
        Value existingValue = this.readRelationshipProperty(propertyKey);
        if (existingValue == Values.NO_VALUE) {
            this.autoIndexing.relationships().propertyAdded(this, relationship, propertyKey, value);
            this.ktx.txState().relationshipDoReplaceProperty(relationship, propertyKey, Values.NO_VALUE, value);
            return Values.NO_VALUE;
        }
        if (this.propertyHasChanged(existingValue, value)) {
            this.autoIndexing.relationships().propertyChanged(this, relationship, propertyKey, existingValue, value);
            this.ktx.txState().relationshipDoReplaceProperty(relationship, propertyKey, existingValue, value);
        }
        return existingValue;
    }

    public Value relationshipRemoveProperty(long relationship, int propertyKey) throws EntityNotFoundException, AutoIndexingKernelException {
        this.acquireExclusiveRelationshipLock(relationship);
        this.ktx.assertOpen();
        this.singleRelationship(relationship);
        Value existingValue = this.readRelationshipProperty(propertyKey);
        if (existingValue != Values.NO_VALUE) {
            this.autoIndexing.relationships().propertyRemoved(this, relationship, propertyKey);
            this.ktx.txState().relationshipDoRemoveProperty(relationship, propertyKey, existingValue);
        }
        return existingValue;
    }

    public Value graphSetProperty(int propertyKey, Value value) {
        this.ktx.locks().optimistic().acquireExclusive(this.ktx.lockTracer(), ResourceTypes.GRAPH_PROPS, ResourceTypes.graphPropertyResource());
        this.ktx.assertOpen();
        Value existingValue = this.readGraphProperty(propertyKey);
        if (!existingValue.equals(value)) {
            this.ktx.txState().graphDoReplaceProperty(propertyKey, existingValue, value);
        }
        return existingValue;
    }

    public Value graphRemoveProperty(int propertyKey) {
        this.ktx.locks().optimistic().acquireExclusive(this.ktx.lockTracer(), ResourceTypes.GRAPH_PROPS, ResourceTypes.graphPropertyResource());
        this.ktx.assertOpen();
        Value existingValue = this.readGraphProperty(propertyKey);
        if (existingValue != Values.NO_VALUE) {
            this.ktx.txState().graphDoRemoveProperty(propertyKey, existingValue);
        }
        return existingValue;
    }

    public void nodeAddToExplicitIndex(String indexName, long node, String key, Object value) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        this.ktx.explicitIndexTxState().nodeChanges(indexName).addNode(node, key, value);
    }

    public void nodeRemoveFromExplicitIndex(String indexName, long node) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        this.ktx.explicitIndexTxState().nodeChanges(indexName).remove(node);
    }

    public void nodeRemoveFromExplicitIndex(String indexName, long node, String key, Object value) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        this.ktx.explicitIndexTxState().nodeChanges(indexName).remove(node, key, value);
    }

    public void nodeRemoveFromExplicitIndex(String indexName, long node, String key) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        this.ktx.explicitIndexTxState().nodeChanges(indexName).remove(node, key);
    }

    public void nodeExplicitIndexCreate(String indexName, Map<String, String> customConfig) {
        this.ktx.assertOpen();
        this.ktx.explicitIndexTxState().createIndex(IndexEntityType.Node, indexName, customConfig);
    }

    public void nodeExplicitIndexCreateLazily(String indexName, Map<String, String> customConfig) {
        this.ktx.assertOpen();
        this.allStoreHolder.getOrCreateNodeIndexConfig(indexName, customConfig);
    }

    public void relationshipAddToExplicitIndex(String indexName, long relationship, String key, Object value) throws KernelException {
        this.ktx.assertOpen();
        this.allStoreHolder.singleRelationship(relationship, this.relationshipCursor);
        if (!this.relationshipCursor.next()) {
            throw new EntityNotFoundException(EntityType.RELATIONSHIP, relationship);
        }
        this.ktx.explicitIndexTxState().relationshipChanges(indexName).addRelationship(relationship, key, value, this.relationshipCursor.sourceNodeReference(), this.relationshipCursor.targetNodeReference());
    }

    public void relationshipRemoveFromExplicitIndex(String indexName, long relationship, String key, Object value) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        this.ktx.explicitIndexTxState().relationshipChanges(indexName).remove(relationship, key, value);
    }

    public void relationshipRemoveFromExplicitIndex(String indexName, long relationship, String key) throws ExplicitIndexNotFoundKernelException {
        this.ktx.explicitIndexTxState().relationshipChanges(indexName).remove(relationship, key);
    }

    public void relationshipRemoveFromExplicitIndex(String indexName, long relationship) throws ExplicitIndexNotFoundKernelException {
        this.ktx.explicitIndexTxState().relationshipChanges(indexName).remove(relationship);
    }

    public void relationshipExplicitIndexCreate(String indexName, Map<String, String> customConfig) {
        this.ktx.assertOpen();
        this.ktx.explicitIndexTxState().createIndex(IndexEntityType.Relationship, indexName, customConfig);
    }

    public void relationshipExplicitIndexCreateLazily(String indexName, Map<String, String> customConfig) {
        this.ktx.assertOpen();
        this.allStoreHolder.getOrCreateRelationshipIndexConfig(indexName, customConfig);
    }

    private Value readNodeProperty(int propertyKey) {
        this.nodeCursor.properties(this.propertyCursor);
        Value existingValue = Values.NO_VALUE;
        while (this.propertyCursor.next()) {
            if (this.propertyCursor.propertyKey() != propertyKey) continue;
            existingValue = this.propertyCursor.propertyValue();
            break;
        }
        return existingValue;
    }

    private Value readRelationshipProperty(int propertyKey) {
        this.relationshipCursor.properties(this.propertyCursor);
        Value existingValue = Values.NO_VALUE;
        while (this.propertyCursor.next()) {
            if (this.propertyCursor.propertyKey() != propertyKey) continue;
            existingValue = this.propertyCursor.propertyValue();
            break;
        }
        return existingValue;
    }

    private Value readGraphProperty(int propertyKey) {
        this.allStoreHolder.graphProperties(this.propertyCursor);
        Value existingValue = Values.NO_VALUE;
        while (this.propertyCursor.next()) {
            if (this.propertyCursor.propertyKey() != propertyKey) continue;
            existingValue = this.propertyCursor.propertyValue();
            break;
        }
        return existingValue;
    }

    public CursorFactory cursors() {
        return this.cursors;
    }

    public void release() {
        if (this.nodeCursor != null) {
            this.nodeCursor.close();
            this.nodeCursor = null;
        }
        if (this.propertyCursor != null) {
            this.propertyCursor.close();
            this.propertyCursor = null;
        }
        if (this.relationshipCursor != null) {
            this.relationshipCursor.close();
            this.relationshipCursor = null;
        }
        this.cursors.release();
    }

    public Token token() {
        return this.token;
    }

    private void acquireExclusiveNodeLock(long node) {
        if (!this.ktx.hasTxStateWithChanges() || !this.ktx.txState().nodeIsAddedInThisTx(node)) {
            this.ktx.locks().optimistic().acquireExclusive(this.ktx.lockTracer(), ResourceTypes.NODE, node);
        }
    }

    private void acquireExclusiveRelationshipLock(long relationshipId) {
        if (!this.ktx.hasTxStateWithChanges() || !this.ktx.txState().relationshipIsAddedInThisTx(relationshipId)) {
            this.ktx.locks().optimistic().acquireExclusive(this.ktx.lockTracer(), ResourceTypes.RELATIONSHIP, relationshipId);
        }
    }

    private void acquireSharedLabelLock(int labelId) {
        this.ktx.locks().optimistic().acquireShared(this.ktx.lockTracer(), ResourceTypes.LABEL, labelId);
    }

    private void sharedRelationshipTypeLock(long typeId) {
        this.ktx.locks().optimistic().acquireShared(this.ktx.lockTracer(), ResourceTypes.RELATIONSHIP_TYPE, typeId);
    }

    private void lockRelationshipNodes(long startNodeId, long endNodeId) {
        this.acquireExclusiveNodeLock(Math.min(startNodeId, endNodeId));
        if (startNodeId != endNodeId) {
            this.acquireExclusiveNodeLock(Math.max(startNodeId, endNodeId));
        }
    }

    private boolean propertyHasChanged(Value lhs, Value rhs) {
        return lhs.getClass() != rhs.getClass() || !lhs.equals(rhs);
    }

    private void assertNodeExists(long sourceNode) throws EntityNotFoundException {
        if (!this.allStoreHolder.nodeExists(sourceNode)) {
            throw new EntityNotFoundException(EntityType.NODE, sourceNode);
        }
    }

    private void assertRelationshipExists(long relationship) throws EntityNotFoundException {
        if (!this.allStoreHolder.relationshipExists(relationship)) {
            throw new EntityNotFoundException(EntityType.RELATIONSHIP, relationship);
        }
    }

    public ExplicitIndexRead indexRead() {
        return this.allStoreHolder;
    }

    public SchemaRead schemaRead() {
        return this.allStoreHolder;
    }

    public Read dataRead() {
        return this.allStoreHolder;
    }

    public DefaultNodeCursor nodeCursor() {
        return this.nodeCursor;
    }

    public DefaultRelationshipScanCursor relationshipCursor() {
        return this.relationshipCursor;
    }

    public DefaultPropertyCursor propertyCursor() {
        return this.propertyCursor;
    }
}

