/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.Arrays;
import org.neo4j.function.ThrowingConsumer;

public abstract class FusionIndexUtils {
    public static <T, E extends Exception> void forAll(ThrowingConsumer<T, E> consumer, Iterable<T> subjects) throws E {
        Exception exception = null;
        for (T subject : subjects) {
            try {
                consumer.accept(subject);
            }
            catch (Throwable t) {
                Exception e = (Exception)t;
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static <T, E extends Exception> void forAll(ThrowingConsumer<T, E> consumer, T ... subjects) throws E {
        FusionIndexUtils.forAll(consumer, Arrays.asList(subjects));
    }
}

