/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import org.neo4j.collection.primitive.PrimitiveLongResourceCollections;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.graphdb.Resource;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexReader;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.kernel.impl.index.schema.TemporalIndexAccessor;
import org.neo4j.kernel.impl.index.schema.TemporalIndexCache;
import org.neo4j.kernel.impl.index.schema.TemporalIndexPartReader;
import org.neo4j.kernel.impl.index.schema.fusion.BridgingIndexProgressor;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexSampler;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexUtils;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

class TemporalIndexReader
extends TemporalIndexCache<TemporalIndexPartReader<?>, IOException>
implements IndexReader {
    private final IndexDescriptor descriptor;

    TemporalIndexReader(IndexDescriptor descriptor, TemporalIndexAccessor accessor) {
        super(new PartFactory(accessor));
        this.descriptor = descriptor;
    }

    public void close() {
        FusionIndexUtils.forAll(Resource::close, this);
    }

    @Override
    public long countIndexedNodes(long nodeId, Value ... propertyValues) {
        NativeSchemaIndexReader partReader = (NativeSchemaIndexReader)this.uncheckedSelect(propertyValues[0].valueGroup());
        return partReader == null ? 0L : partReader.countIndexedNodes(nodeId, propertyValues);
    }

    @Override
    public IndexSampler createSampler() {
        return new FusionIndexSampler((IndexSampler[])Iterators.stream(this.iterator()).map(IndexReader::createSampler).toArray(IndexSampler[]::new));
    }

    @Override
    public PrimitiveLongResourceIterator query(IndexQuery ... predicates) {
        if (predicates[0] instanceof IndexQuery.ExistsPredicate) {
            return PrimitiveLongResourceCollections.concat((Iterable)Iterables.map(partReader -> partReader.query(predicates), (Iterable)this));
        }
        NodeValueIterator nodeValueIterator = new NodeValueIterator();
        this.query(nodeValueIterator, IndexOrder.NONE, predicates);
        return nodeValueIterator;
    }

    @Override
    public void query(IndexProgressor.NodeValueClient cursor, IndexOrder indexOrder, IndexQuery ... predicates) {
        NativeSchemaIndexReader part;
        if (predicates[0] instanceof IndexQuery.ExistsPredicate) {
            BridgingIndexProgressor multiProgressor = new BridgingIndexProgressor(cursor, this.descriptor.schema().getPropertyIds());
            cursor.initialize(this.descriptor, multiProgressor, predicates);
            for (NativeSchemaIndexReader reader : this) {
                reader.query(multiProgressor, indexOrder, predicates);
            }
        } else if (this.validPredicates(predicates) && (part = (NativeSchemaIndexReader)this.uncheckedSelect(predicates[0].valueGroup())) != null) {
            part.query(cursor, indexOrder, predicates);
        }
    }

    @Override
    public boolean hasFullValuePrecision(IndexQuery ... predicates) {
        return true;
    }

    private boolean validPredicates(IndexQuery[] predicates) {
        return predicates[0] instanceof IndexQuery.ExactPredicate || predicates[0] instanceof IndexQuery.GeometryRangePredicate;
    }

    static class PartFactory
    implements TemporalIndexCache.Factory<TemporalIndexPartReader<?>, IOException> {
        private final TemporalIndexAccessor accessor;

        PartFactory(TemporalIndexAccessor accessor) {
            this.accessor = accessor;
        }

        @Override
        public TemporalIndexPartReader<?> newDate() throws IOException {
            return this.accessor.selectOrElse(ValueGroup.DATE, TemporalIndexAccessor.PartAccessor::newReader, null);
        }

        @Override
        public TemporalIndexPartReader<?> newDateTime() {
            throw new UnsupportedOperationException("Illiterate");
        }

        @Override
        public TemporalIndexPartReader<?> newDateTimeZoned() {
            throw new UnsupportedOperationException("Illiterate");
        }

        @Override
        public TemporalIndexPartReader<?> newTime() {
            throw new UnsupportedOperationException("Illiterate");
        }

        @Override
        public TemporalIndexPartReader<?> newTimeZoned() {
            throw new UnsupportedOperationException("Illiterate");
        }

        @Override
        public TemporalIndexPartReader<?> newDuration() {
            throw new UnsupportedOperationException("Illiterate");
        }
    }
}

