/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.values.storable.ValueGroup;

class TemporalIndexCache<T, E extends Exception>
implements Iterable<T> {
    private final Factory<T, E> factory;
    private volatile T date;
    private volatile T dateTime;
    private volatile T dateTimeZoned;
    private volatile T time;
    private volatile T timeZoned;
    private volatile T duration;

    TemporalIndexCache(Factory<T, E> factory) {
        this.factory = factory;
    }

    T uncheckedSelect(ValueGroup valueGroup) {
        try {
            return this.select(valueGroup);
        }
        catch (Exception t) {
            throw new RuntimeException(t);
        }
    }

    T select(ValueGroup valueGroup) throws E {
        switch (valueGroup) {
            case DATE: {
                return this.date();
            }
            case LOCAL_DATE_TIME: {
                return this.dateTime();
            }
            case ZONED_DATE_TIME: {
                return this.dateTimeZoned();
            }
            case LOCAL_TIME: {
                return this.time();
            }
            case ZONED_TIME: {
                return this.timeZoned();
            }
            case DURATION: {
                return this.duration();
            }
        }
        throw new IllegalStateException("Unsupported value group " + valueGroup);
    }

    <RESULT> RESULT selectOrElse(ValueGroup valueGroup, Function<T, RESULT> function, RESULT orElse) {
        switch (valueGroup) {
            case DATE: {
                return this.date != null ? function.apply(this.date) : orElse;
            }
            case LOCAL_DATE_TIME: {
                return this.dateTime != null ? function.apply(this.dateTime) : orElse;
            }
            case ZONED_DATE_TIME: {
                return this.dateTimeZoned != null ? function.apply(this.dateTimeZoned) : orElse;
            }
            case LOCAL_TIME: {
                return this.time != null ? function.apply(this.time) : orElse;
            }
            case ZONED_TIME: {
                return this.timeZoned != null ? function.apply(this.timeZoned) : orElse;
            }
            case DURATION: {
                return this.duration != null ? function.apply(this.duration) : orElse;
            }
        }
        throw new IllegalStateException("Unsupported value group " + valueGroup);
    }

    T date() throws E {
        if (this.date == null) {
            this.date = this.factory.newDate();
        }
        return this.date;
    }

    T dateTime() throws E {
        if (this.dateTime == null) {
            this.dateTime = this.factory.newDateTime();
        }
        return this.dateTime;
    }

    T dateTimeZoned() throws E {
        if (this.dateTimeZoned == null) {
            this.dateTimeZoned = this.factory.newDateTimeZoned();
        }
        return this.dateTimeZoned;
    }

    T time() throws E {
        if (this.time == null) {
            this.time = this.factory.newTime();
        }
        return this.time;
    }

    T timeZoned() throws E {
        if (this.timeZoned == null) {
            this.timeZoned = this.factory.newTimeZoned();
        }
        return this.timeZoned;
    }

    T duration() throws E {
        if (this.duration == null) {
            this.duration = this.factory.newDuration();
        }
        return this.duration;
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.filter(Objects::nonNull, (Iterator)Iterators.iterator((Object[])new Object[]{this.date, this.dateTime, this.dateTimeZoned, this.time, this.timeZoned, this.duration}));
    }

    static interface Factory<T, E extends Exception> {
        public T newDate() throws E;

        public T newDateTime() throws E;

        public T newDateTimeZoned() throws E;

        public T newTime() throws E;

        public T newTimeZoned() throws E;

        public T newDuration() throws E;
    }
}

