/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.string.UTF8;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.UTF8StringValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

class StringSchemaKey
extends ValueWriter.Adapter<RuntimeException>
implements NativeSchemaKey {
    static final int ENTITY_ID_SIZE = 8;
    private long entityId;
    private boolean compareId;
    byte[] bytes;

    StringSchemaKey() {
    }

    @Override
    public void setCompareId(boolean compareId) {
        this.compareId = compareId;
    }

    @Override
    public boolean getCompareId() {
        return this.compareId;
    }

    int size() {
        return 8 + this.bytes.length;
    }

    @Override
    public long getEntityId() {
        return this.entityId;
    }

    @Override
    public void setEntityId(long entityId) {
        this.entityId = entityId;
    }

    @Override
    public void from(long entityId, Value ... values) {
        this.entityId = entityId;
        this.compareId = false;
        this.assertValidValue(values).writeTo((ValueWriter)this);
    }

    private TextValue assertValidValue(Value ... values) {
        if (values.length > 1) {
            throw new IllegalArgumentException("Tried to create composite key with non-composite schema key layout");
        }
        if (values.length < 1) {
            throw new IllegalArgumentException("Tried to create key without value");
        }
        if (!Values.isTextValue((Object)values[0])) {
            throw new IllegalArgumentException("Key layout does only support strings, tried to create key from " + values[0]);
        }
        return (TextValue)values[0];
    }

    @Override
    public String propertiesAsString() {
        return this.asValue().toString();
    }

    @Override
    public Value asValue() {
        return this.bytes == null ? Values.NO_VALUE : Values.utf8Value((byte[])this.bytes);
    }

    @Override
    public void initAsLowest() {
        this.bytes = null;
        this.entityId = Long.MIN_VALUE;
        this.compareId = true;
    }

    @Override
    public void initAsHighest() {
        this.bytes = null;
        this.entityId = Long.MAX_VALUE;
        this.compareId = true;
    }

    private boolean isHighest() {
        return this.compareId && this.entityId == Long.MAX_VALUE && this.bytes == null;
    }

    int compareValueTo(StringSchemaKey other) {
        if (this.bytes != other.bytes) {
            if (this.bytes == null) {
                return this.isHighest() ? 1 : -1;
            }
            if (other.bytes == null) {
                return other.isHighest() ? -1 : 1;
            }
        } else {
            return 0;
        }
        try {
            return UTF8StringValue.codePointByteArrayCompare((byte[])this.bytes, (byte[])other.bytes);
        }
        catch (Exception e) {
            return StringSchemaKey.byteArrayCompare(this.bytes, other.bytes);
        }
    }

    private static int byteArrayCompare(byte[] a, byte[] b) {
        assert (a != null && b != null) : "Null arrays not supported.";
        if (a == b) {
            return 0;
        }
        int length = Math.min(a.length, b.length);
        for (int i = 0; i < length; ++i) {
            int compare = Byte.compare(a[i], b[i]);
            if (compare == 0) continue;
            return compare;
        }
        return Integer.compare(a.length, b.length);
    }

    @Override
    public String toString() {
        return String.format("value=%s,entityId=%d,bytes=%s", this.asValue(), this.entityId, Arrays.toString(this.bytes));
    }

    public void writeString(String value) {
        this.bytes = UTF8.encode((String)value);
    }

    public void writeString(char value) {
        throw new UnsupportedOperationException("Not supported a.t.m. should it be?");
    }
}

