/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.CapabilityValidator;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexReader;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.StringSchemaIndexProvider;
import org.neo4j.kernel.impl.index.schema.StringSchemaKey;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

class StringSchemaIndexReader
extends NativeSchemaIndexReader<StringSchemaKey, NativeSchemaValue> {
    StringSchemaIndexReader(GBPTree<StringSchemaKey, NativeSchemaValue> tree, Layout<StringSchemaKey, NativeSchemaValue> layout, IndexSamplingConfig samplingConfig, IndexDescriptor descriptor) {
        super(tree, layout, samplingConfig, descriptor);
    }

    @Override
    void validateQuery(IndexOrder indexOrder, IndexQuery[] predicates) {
        if (predicates.length != 1) {
            throw new UnsupportedOperationException();
        }
        CapabilityValidator.validateQuery(StringSchemaIndexProvider.CAPABILITY, indexOrder, predicates);
    }

    @Override
    void initializeRangeForQuery(StringSchemaKey treeKeyFrom, StringSchemaKey treeKeyTo, IndexQuery[] predicates) {
        IndexQuery predicate = predicates[0];
        switch (predicate.type()) {
            case exists: {
                treeKeyFrom.initAsLowest();
                treeKeyTo.initAsHighest();
                break;
            }
            case exact: {
                IndexQuery.ExactPredicate exactPredicate = (IndexQuery.ExactPredicate)predicate;
                treeKeyFrom.from(Long.MIN_VALUE, exactPredicate.value());
                treeKeyTo.from(Long.MAX_VALUE, exactPredicate.value());
                break;
            }
            case rangeString: {
                IndexQuery.StringRangePredicate rangePredicate = (IndexQuery.StringRangePredicate)predicate;
                this.initFromForRange(rangePredicate, treeKeyFrom);
                this.initToForRange(rangePredicate, treeKeyTo);
                break;
            }
            default: {
                throw new IllegalArgumentException("IndexQuery of type " + predicate.type() + " is not supported.");
            }
        }
    }

    private void initFromForRange(IndexQuery.StringRangePredicate rangePredicate, StringSchemaKey treeKeyFrom) {
        Value fromValue = rangePredicate.fromAsValue();
        if (fromValue.valueGroup() == ValueGroup.NO_VALUE) {
            treeKeyFrom.initAsLowest();
        } else {
            treeKeyFrom.from(rangePredicate.fromInclusive() ? Long.MIN_VALUE : Long.MAX_VALUE, fromValue);
            treeKeyFrom.setCompareId(true);
        }
    }

    private void initToForRange(IndexQuery.StringRangePredicate rangePredicate, StringSchemaKey treeKeyTo) {
        Value toValue = rangePredicate.toAsValue();
        if (toValue.valueGroup() == ValueGroup.NO_VALUE) {
            treeKeyTo.initAsHighest();
        } else {
            treeKeyTo.from(rangePredicate.toInclusive() ? Long.MAX_VALUE : Long.MIN_VALUE, toValue);
            treeKeyTo.setCompareId(true);
        }
    }

    @Override
    public boolean hasFullValuePrecision(IndexQuery ... predicates) {
        return false;
    }
}

